/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.chromattic.api.ChromatticException;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.Status;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.api.event.EventListener;
import org.chromattic.api.query.ObjectQueryBuilder;
import org.chromattic.common.JCR;
import org.chromattic.core.Domain;
import org.chromattic.core.EventBroadcaster;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.jcr.LinkType;
import org.chromattic.core.query.ObjectQueryBuilderImpl;
import org.chromattic.core.query.QueryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DomainSession
implements ChromatticSession {
    protected final EventBroadcaster broadcaster;
    final Domain domain;
    private final QueryManager queryManager;

    protected DomainSession(Domain domain) {
        this.domain = domain;
        this.broadcaster = new EventBroadcaster();
        this.queryManager = new QueryManager(this);
    }

    protected abstract String _persist(ObjectContext var1, String var2) throws RepositoryException;

    protected abstract String _persist(ObjectContext var1, String var2, ObjectContext var3) throws RepositoryException;

    protected abstract <O> O _create(Class<O> var1, String var2) throws NullPointerException, IllegalArgumentException, RepositoryException;

    protected abstract <O> O _findById(Class<O> var1, String var2) throws RepositoryException;

    protected abstract void _save() throws RepositoryException;

    protected abstract void _remove(Object var1) throws RepositoryException;

    protected abstract void _remove(ObjectContext var1) throws RepositoryException;

    protected abstract Object _getReferenced(ObjectContext var1, String var2, LinkType var3) throws RepositoryException;

    protected abstract boolean _setReferenced(ObjectContext var1, String var2, ObjectContext var3, LinkType var4) throws RepositoryException;

    protected abstract <T> Iterator<T> _getReferents(ObjectContext var1, String var2, Class<T> var3, LinkType var4) throws RepositoryException;

    protected abstract void _removeChild(ObjectContext var1, String var2) throws RepositoryException;

    protected abstract Object _getChild(ObjectContext var1, String var2) throws RepositoryException;

    protected abstract <T> Iterator<T> _getChildren(ObjectContext var1, Class<T> var2) throws RepositoryException;

    protected abstract Object _getParent(ObjectContext var1) throws RepositoryException;

    protected abstract <O> O _findByPath(Object var1, Class<O> var2, String var3) throws RepositoryException;

    protected abstract void _orderBefore(ObjectContext var1, ObjectContext var2, ObjectContext var3) throws RepositoryException;

    public final String getId(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        ObjectContext ctx = this.unwrap(o);
        return ctx.getId();
    }

    public final String getName(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        ObjectContext ctx = this.unwrap(o);
        return this.getName(ctx);
    }

    public final String getPath(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        ObjectContext ctx = this.unwrap(o);
        return ctx.getPath();
    }

    public final <O> O create(Class<O> clazz) throws NullPointerException, IllegalArgumentException {
        return this.create(clazz, null);
    }

    public final <O> O create(Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException {
        try {
            return this._create(clazz, name);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final <O> O insert(Object parent, Class<O> clazz, String relPath) throws NullPointerException, IllegalArgumentException, ChromatticException {
        ObjectContext parentCtx = this.unwrap(parent);
        O child = this.create(clazz);
        ObjectContext childtx = this.unwrap(child);
        this.persistWithRelativePath(parentCtx, relPath, childtx);
        return child;
    }

    public final <O> O insert(Class<O> clazz, String relPath) throws NullPointerException, IllegalArgumentException, UndeclaredRepositoryException {
        O child = this.create(clazz);
        this.persist(child, relPath);
        return child;
    }

    public final String persist(Object parent, Object child, String relPath) throws NullPointerException, IllegalArgumentException, ChromatticException {
        try {
            ObjectContext parentCtx = this.unwrap(parent);
            ObjectContext childCtx = this.unwrap(child);
            return this._persist(parentCtx, relPath, childCtx);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException();
        }
    }

    public final String persist(Object parent, Object child) throws NullPointerException, IllegalArgumentException, ChromatticException {
        ObjectContext parentCtx = this.unwrap(parent);
        ObjectContext childCtx = this.unwrap(child);
        String name = childCtx.state.getName();
        if (name == null) {
            String msg = "Attempt to persist non named object " + childCtx;
            throw new IllegalArgumentException(msg);
        }
        try {
            return this._persist(parentCtx, name, childCtx);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final String persist(Object o) throws NullPointerException, IllegalArgumentException, ChromatticException {
        try {
            ObjectContext ctx = this.unwrap(o);
            String name = ctx.state.getName();
            if (name == null) {
                String msg = "Attempt to persist non named object " + ctx;
                throw new IllegalArgumentException(msg);
            }
            return this._persist(ctx, name);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final String persist(Object o, String relPath) throws NullPointerException, IllegalArgumentException, ChromatticException {
        try {
            ObjectContext ctx = this.unwrap(o);
            return this._persist(ctx, relPath);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final <O> O findByNode(Class<O> clazz, Node node) throws UndeclaredRepositoryException {
        if (node == null) {
            throw new NullPointerException();
        }
        try {
            if (this.domain.getTypeMapper(node.getPrimaryNodeType().getName()) != null) {
                return this.findById(clazz, node.getUUID());
            }
            return null;
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final <O> O findById(Class<O> clazz, String id) throws UndeclaredRepositoryException {
        try {
            return this._findById(clazz, id);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final <O> O findByPath(Object o, Class<O> clazz, String relPath) throws ChromatticException {
        if (o == null) {
            throw new NullPointerException();
        }
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (relPath == null) {
            throw new NullPointerException();
        }
        try {
            return this._findByPath(o, clazz, relPath);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final <O> O findByPath(Class<O> clazz, String relPath) throws ChromatticException {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (relPath == null) {
            throw new NullPointerException();
        }
        try {
            return this._findByPath(null, clazz, relPath);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final void save() throws UndeclaredRepositoryException {
        try {
            this._save();
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final Status getStatus(Object o) throws UndeclaredRepositoryException {
        if (o == null) {
            throw new NullPointerException();
        }
        ObjectContext ctx = this.unwrap(o);
        return ctx.getStatus();
    }

    public final void remove(Object o) throws UndeclaredRepositoryException {
        try {
            this._remove(o);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public ObjectQueryBuilder<?> createQueryBuilder() throws ChromatticException {
        return new ObjectQueryBuilderImpl(this.domain, this.queryManager);
    }

    public final Node getNode(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        ObjectContext ctx = this.unwrap(o);
        return ctx.state.getNode();
    }

    public final String encodeName(String external) {
        String internal;
        if (external == null) {
            throw new NullPointerException("No null name accepted");
        }
        try {
            internal = this.domain.objectFormatter.encodeNodeName(null, external);
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                throw (NullPointerException)e;
            }
            if (e instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
        if (internal == null) {
            throw new IllegalArgumentException("Name " + external + " was converted to null");
        }
        JCR.validateName((String)internal);
        return internal;
    }

    public final String decodeName(String internal) {
        String external;
        try {
            external = this.domain.objectFormatter.decodeNodeName(null, internal);
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException) {
                throw (IllegalStateException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
        if (external == null) {
            throw new IllegalStateException("Null name returned by decoder");
        }
        return external;
    }

    public final String getName(ObjectContext ctx) throws UndeclaredRepositoryException {
        if (ctx == null) {
            throw new NullPointerException();
        }
        String name = ctx.state.getName();
        if (name != null) {
            name = this.decodeName(name);
        }
        return name;
    }

    public final void setName(ObjectContext ctx, String name) throws UndeclaredRepositoryException {
        if (ctx == null) {
            throw new NullPointerException();
        }
        name = this.encodeName(name);
        ctx.state.setName(name);
    }

    public final String persist(ObjectContext relatativeCtx, String name, ObjectContext siblingCtx) throws UndeclaredRepositoryException {
        try {
            String path = name = this.encodeName(name);
            return this._persist(relatativeCtx, path, siblingCtx);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final void orderBefore(ObjectContext parentCtx, ObjectContext srcCtx, ObjectContext dstCtx) {
        try {
            this._orderBefore(parentCtx, srcCtx, dstCtx);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final String persistWithName(ObjectContext parentCtx, String name, ObjectContext childCtx) throws UndeclaredRepositoryException {
        try {
            String path = name = this.encodeName(name);
            return this._persist(parentCtx, path, childCtx);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final String persistWithRelativePath(ObjectContext parentCtx, String relPath, ObjectContext childCtx) throws UndeclaredRepositoryException {
        try {
            return this._persist(parentCtx, relPath, childCtx);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final void remove(ObjectContext context) throws UndeclaredRepositoryException {
        try {
            this._remove(context);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final Object getReferenced(ObjectContext referentCtx, String name, LinkType linkType) throws UndeclaredRepositoryException {
        try {
            return this._getReferenced(referentCtx, name, linkType);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final boolean setReferenced(ObjectContext referentCtx, String name, ObjectContext referencedCtx, LinkType linkType) throws UndeclaredRepositoryException {
        try {
            return this._setReferenced(referentCtx, name, referencedCtx, linkType);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final void removeChild(ObjectContext ctx, String name) throws UndeclaredRepositoryException {
        try {
            this._removeChild(ctx, name);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final Object getChild(ObjectContext ctx, String name) throws UndeclaredRepositoryException {
        try {
            return this._getChild(ctx, name);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final <T> Iterator<T> getChildren(ObjectContext ctx, Class<T> filterClass) throws UndeclaredRepositoryException {
        try {
            return this._getChildren(ctx, filterClass);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final Object getParent(ObjectContext ctx) throws UndeclaredRepositoryException {
        try {
            return this._getParent(ctx);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final <T> Iterator<T> getReferents(ObjectContext referencedCtx, String name, Class<T> filterClass, LinkType linkType) throws UndeclaredRepositoryException {
        try {
            return this._getReferents(referencedCtx, name, filterClass, linkType);
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    public final ObjectContext unwrap(Object o) {
        if (o == null) {
            throw new NullPointerException("Cannot unwrap null object");
        }
        return (ObjectContext)this.domain.getInstrumentor().getInvoker(o);
    }

    public void addEventListener(EventListener listener) {
        this.broadcaster.addLifeCycleListener(listener);
    }
}

