/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper.property;

import org.chromattic.core.EntityContext;
import org.chromattic.core.ListType;
import org.chromattic.core.bean.ArrayPropertyInfo;
import org.chromattic.core.bean.ListPropertyInfo;
import org.chromattic.core.bean.MultiValuedPropertyInfo;
import org.chromattic.core.bean.SimpleValueInfo;
import org.chromattic.core.mapper.PropertyMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRPropertyListPropertyMapper
extends PropertyMapper<MultiValuedPropertyInfo<SimpleValueInfo>> {
    private final String jcrPropertyName;
    private final ListType listType;

    public JCRPropertyListPropertyMapper(MultiValuedPropertyInfo<SimpleValueInfo> info, String jcrPropertyName) {
        super(info);
        ListType<Object> listType;
        if (info instanceof ArrayPropertyInfo) {
            listType = ListType.ARRAY;
        } else if (info instanceof ListPropertyInfo) {
            listType = ListType.LIST;
        } else {
            throw new AssertionError();
        }
        this.listType = listType;
        this.jcrPropertyName = jcrPropertyName;
    }

    @Override
    public Object get(EntityContext context) throws Throwable {
        return context.getPropertyValues(this.jcrPropertyName, (SimpleValueInfo)((MultiValuedPropertyInfo)this.info).getElementValue(), this.listType);
    }

    @Override
    public void set(EntityContext context, Object value) throws Throwable {
        context.setPropertyValues(this.jcrPropertyName, (SimpleValueInfo)((MultiValuedPropertyInfo)this.info).getElementValue(), this.listType, value);
    }
}

