/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapping;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.chromattic.api.NameConflictResolution;
import org.chromattic.core.mapping.MethodMapping;
import org.chromattic.core.mapping.PropertyMapping;
import org.reflext.api.ClassTypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMapping {
    private final ClassTypeInfo objectClass;
    private final Set<PropertyMapping> propertyMappings;
    private final Set<MethodMapping> methodMappings;
    private final String nodeTypeName;
    private final Set<String> mixinNames;
    private final NameConflictResolution onDuplicate;

    public TypeMapping(ClassTypeInfo objectClass, Set<PropertyMapping> propertyMappings, Set<MethodMapping> methodMappings, String nodeTypeName, Set<String> mixinNames, NameConflictResolution onDuplicate) {
        this.objectClass = objectClass;
        this.propertyMappings = Collections.unmodifiableSet(new HashSet<PropertyMapping>(propertyMappings));
        this.methodMappings = Collections.unmodifiableSet(new HashSet<MethodMapping>(methodMappings));
        this.nodeTypeName = nodeTypeName;
        this.mixinNames = mixinNames;
        this.onDuplicate = onDuplicate;
    }

    public ClassTypeInfo getObjectClass() {
        return this.objectClass;
    }

    public Set<String> getMixinNames() {
        return this.mixinNames;
    }

    public String getNodeTypeName() {
        return this.nodeTypeName;
    }

    public Set<PropertyMapping> getPropertyMappings() {
        return this.propertyMappings;
    }

    public Set<MethodMapping> getMethodMappings() {
        return this.methodMappings;
    }

    public NameConflictResolution getOnDuplicate() {
        return this.onDuplicate;
    }

    public int hashCode() {
        return this.objectClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TypeMapping) {
            TypeMapping that = (TypeMapping)obj;
            return this.objectClass.equals(that.objectClass);
        }
        return false;
    }

    public String toString() {
        return "JavaTypeInfo[objectClass=" + this.objectClass.getName() + ",nodeTypeName=" + this.nodeTypeName + "]";
    }
}

