/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import org.chromattic.api.Status;
import org.chromattic.common.CloneableInputStream;
import org.chromattic.common.CopyingInputStream;
import org.chromattic.common.JCR;
import org.chromattic.common.logging.Logger;
import org.chromattic.core.DomainSession;
import org.chromattic.core.EntityContextState;
import org.chromattic.core.EventBroadcaster;
import org.chromattic.core.ListType;
import org.chromattic.core.NodeAttributeType;
import org.chromattic.core.PropertyMap;
import org.chromattic.core.TransientEntityContextState;
import org.chromattic.core.bean.SimpleValueInfo;
import org.chromattic.core.jcr.LinkType;
import org.chromattic.core.mapper.TypeMapper;
import org.chromattic.spi.instrument.MethodHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityContext
implements MethodHandler {
    private final Logger log = Logger.getLogger(EntityContext.class);
    final TypeMapper mapper;
    final Object object;
    final PropertyMap properties;
    EntityContextState state = null;

    public EntityContext(TypeMapper mapper) {
        this(mapper, null);
    }

    public EntityContext(TypeMapper mapper, TransientEntityContextState state) {
        this.mapper = mapper;
        this.object = mapper.createObject(this);
        this.state = state;
        this.properties = new PropertyMap(this);
    }

    public DomainSession getSession() {
        return this.state.getSession();
    }

    public Status getStatus() {
        return this.state.getStatus();
    }

    public Object getObject() {
        return this.object;
    }

    public String getAttribute(NodeAttributeType type) {
        DomainSession session = this.state.getSession();
        switch (type) {
            case NAME: {
                return session.getName(this);
            }
            case ID: {
                return this.state.getId();
            }
            case PATH: {
                return this.state.getPath();
            }
            case WORKSPACE_NAME: {
                return session.getJCRSession().getWorkspace().getName();
            }
        }
        throw new AssertionError();
    }

    public void remove() {
        this.state.getSession().remove(this);
    }

    public <T> Iterator<T> getReferents(String name, Class<T> filterClass, LinkType linkType) {
        return this.state.getSession().getReferents(this, name, filterClass, linkType);
    }

    public String getName() {
        return this.getAttribute(NodeAttributeType.NAME);
    }

    public String getId() {
        return this.getAttribute(NodeAttributeType.ID);
    }

    public String getPath() {
        return this.getAttribute(NodeAttributeType.PATH);
    }

    public void setName(String name) {
        this.state.getSession().setName(this, name);
    }

    public Object getReferenced(String name, LinkType linkType) {
        return this.state.getSession().getReferenced(this, name, linkType);
    }

    public void setReferenced(String name, Object referenced, LinkType linkType) {
        DomainSession session = this.state.getSession();
        EntityContext referencedCtx = null;
        if (referenced != null) {
            referencedCtx = session.unwrap(referenced);
        }
        session.setReferenced(this, name, referencedCtx, linkType);
    }

    public boolean addReference(String name, Object referent, LinkType linkType) {
        DomainSession session = this.state.getSession();
        EntityContext referentCtx = session.unwrap(referent);
        return session.setReferenced(referentCtx, name, this, linkType);
    }

    public Map<String, Object> getPropertyMap() {
        return this.properties;
    }

    public Object getPropertyValue(String propertyName, SimpleValueInfo type) {
        JCR.validateName((String)propertyName);
        return this.state.getPropertyValue(propertyName, type);
    }

    public <T> T getPropertyValues(String propertyName, SimpleValueInfo simpleType, ListType<T> listType) {
        JCR.validateName((String)propertyName);
        return this.state.getPropertyValues(propertyName, simpleType, listType);
    }

    public void setPropertyValue(String propertyName, SimpleValueInfo type, Object o) {
        JCR.validateName((String)propertyName);
        EventBroadcaster broadcaster = this.state.getSession().broadcaster;
        if (o instanceof InputStream && broadcaster.hasStateChangeListeners()) {
            CopyingInputStream in = new CopyingInputStream((InputStream)o);
            this.state.setPropertyValue(propertyName, type, in);
            byte[] bytes = in.getBytes();
            broadcaster.propertyChanged(this.object, propertyName, new CloneableInputStream(bytes));
        } else {
            this.state.setPropertyValue(propertyName, type, o);
            broadcaster.propertyChanged(this.object, propertyName, o);
        }
    }

    public <T> void setPropertyValues(String propertyName, SimpleValueInfo type, ListType<T> listType, T objects) {
        JCR.validateName((String)propertyName);
        this.state.setPropertyValues(propertyName, type, listType, objects);
    }

    public void removeChild(String name) {
        if (this.getStatus() != Status.PERSISTENT) {
            throw new IllegalStateException("Can only insert/remove a child of a persistent object");
        }
        this.state.getSession().removeChild(this, name);
    }

    public void orderBefore(EntityContext srcCtx, EntityContext dstCtx) {
        this.state.getSession().orderBefore(this, srcCtx, dstCtx);
    }

    public void addChild(EntityContext childCtx) {
        String name = childCtx.state.getName();
        this.addChild(name, childCtx);
    }

    public void addChild(Object child) {
        DomainSession session = this.state.getSession();
        EntityContext childCtx = session.unwrap(child);
        this.addChild(childCtx);
    }

    public void addChild(String name, EntityContext childCtx) {
        if (childCtx.getStatus() == Status.PERSISTENT) {
            this.state.getSession().move(childCtx, this);
        } else {
            this.state.getSession().persistWithName(this, name, childCtx);
        }
    }

    public void addChild(String name, Object child) {
        DomainSession session = this.state.getSession();
        EntityContext childCtx = session.unwrap(child);
        this.addChild(name, childCtx);
    }

    public Object getChild(String name) {
        return this.state.getSession().getChild(this, name);
    }

    public <T> Iterator<T> getChildren(Class<T> filterClass) {
        return this.state.getSession().getChildren(this, filterClass);
    }

    public Object getParent() {
        return this.state.getSession().getParent(this);
    }

    public String toString() {
        return "ObjectContext[status=" + this.state + ",mapper=" + this.mapper + "]";
    }

    public Object invoke(Object o, Method method, Object[] args) throws Throwable {
        return this.mapper.invoke(this, method, args);
    }
}

