/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.chromattic.api.format.ObjectFormatter;
import org.chromattic.core.jcr.info.NodeInfoManager;
import org.chromattic.core.mapper.TypeMapper;
import org.chromattic.core.mapper.TypeMapperBuilder;
import org.chromattic.core.mapping.TypeMapping;
import org.chromattic.core.query.QueryManager;
import org.chromattic.spi.instrument.Instrumentor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain {
    private final Map<String, TypeMapper> typeMapperByNodeType;
    private final Map<Class<?>, TypeMapper> typeMapperByClass;
    private final Instrumentor instrumentor;
    final ObjectFormatter objectFormatter;
    final boolean stateCacheEnabled;
    final boolean hasPropertyOptimized;
    final boolean hasNodeOptimized;
    final String rootNodePath;
    final NodeInfoManager nodeInfoManager;
    final QueryManager queryManager;

    public Domain(Set<TypeMapping> typeMappings, Instrumentor instrumentor, ObjectFormatter objectFormatter, boolean stateCacheEnabled, boolean hasPropertyOptimized, boolean hasNodeOptimized, String rootNodePath) {
        TypeMapperBuilder builder = new TypeMapperBuilder(typeMappings, instrumentor);
        HashMap<String, TypeMapper> typeMapperByNodeType = new HashMap<String, TypeMapper>();
        HashMap typeMapperByClass = new HashMap();
        for (TypeMapper typeMapper : builder.build()) {
            if (typeMapperByNodeType.containsKey(typeMapper.getTypeName())) {
                throw new IllegalStateException("Duplicate node type name " + typeMapper);
            }
            typeMapperByNodeType.put(typeMapper.getTypeName(), typeMapper);
            typeMapperByClass.put(typeMapper.getObjectClass(), typeMapper);
        }
        this.typeMapperByClass = typeMapperByClass;
        this.typeMapperByNodeType = typeMapperByNodeType;
        this.instrumentor = instrumentor;
        this.objectFormatter = objectFormatter;
        this.stateCacheEnabled = stateCacheEnabled;
        this.hasPropertyOptimized = hasPropertyOptimized;
        this.hasNodeOptimized = hasNodeOptimized;
        this.rootNodePath = rootNodePath;
        this.nodeInfoManager = new NodeInfoManager();
        this.queryManager = new QueryManager();
    }

    public boolean isHasPropertyOptimized() {
        return this.hasPropertyOptimized;
    }

    public boolean isHasNodeOptimized() {
        return this.hasNodeOptimized;
    }

    public Instrumentor getInstrumentor() {
        return this.instrumentor;
    }

    public TypeMapper getTypeMapper(String nodeTypeName) {
        return this.typeMapperByNodeType.get(nodeTypeName);
    }

    public TypeMapper getTypeMapper(Class<?> clazz) {
        return this.typeMapperByClass.get(clazz);
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }
}

