/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.chromattic.api.BuilderException;
import org.chromattic.api.format.ObjectFormatter;
import org.chromattic.common.collection.Collections;
import org.chromattic.common.jcr.Path;
import org.chromattic.common.jcr.PathException;
import org.chromattic.core.EntityContext;
import org.chromattic.core.NameKind;
import org.chromattic.core.jcr.info.NodeInfoManager;
import org.chromattic.core.mapper.MapperBuilder;
import org.chromattic.core.mapper.ObjectMapper;
import org.chromattic.core.mapping.NodeTypeMapping;
import org.chromattic.core.query.QueryManager;
import org.chromattic.spi.instrument.Instrumentor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Domain {
    public static int LAZY_CREATE_MODE = 0;
    public static int CREATE_MODE = 1;
    public static int NO_CREATE = 2;
    private static final Set<Integer> CREATE_MODES = Collections.set((Object[])new Integer[]{LAZY_CREATE_MODE, CREATE_MODE, NO_CREATE});
    private final Map<String, ObjectMapper> typeMapperByNodeType;
    private final Map<Class<?>, ObjectMapper> typeMapperByClass;
    private final Instrumentor instrumentor;
    final ObjectFormatter objectFormatter;
    final boolean stateCacheEnabled;
    final boolean hasPropertyOptimized;
    final boolean hasNodeOptimized;
    final String rootNodePath;
    final List<String> rootNodePathSegments;
    final int rootCreateMode;
    final NodeInfoManager nodeInfoManager;
    final QueryManager queryManager;

    public Domain(Set<NodeTypeMapping> typeMappings, Instrumentor instrumentor, ObjectFormatter objectFormatter, boolean stateCacheEnabled, boolean hasPropertyOptimized, boolean hasNodeOptimized, String rootNodePath, int rootCreateMode) {
        List rootNodePathSegments;
        MapperBuilder builder = new MapperBuilder(typeMappings, instrumentor);
        if (!CREATE_MODES.contains(rootCreateMode)) {
            throw new IllegalArgumentException("Invalid create mode " + rootCreateMode);
        }
        HashMap<String, ObjectMapper> typeMapperByNodeType = new HashMap<String, ObjectMapper>();
        HashMap typeMapperByClass = new HashMap();
        for (ObjectMapper typeMapper : builder.build()) {
            if (typeMapperByNodeType.containsKey(typeMapper.getNodeTypeName())) {
                throw new IllegalStateException("Duplicate node type name " + typeMapper);
            }
            typeMapperByNodeType.put(typeMapper.getNodeTypeName(), typeMapper);
            typeMapperByClass.put(typeMapper.getObjectClass(), typeMapper);
        }
        try {
            rootNodePathSegments = Path.splitAbsolutePath((String)Path.normalizeAbsolutePath((String)rootNodePath));
        }
        catch (PathException e) {
            throw new BuilderException("Root node path must be valid");
        }
        this.typeMapperByClass = typeMapperByClass;
        this.typeMapperByNodeType = typeMapperByNodeType;
        this.instrumentor = instrumentor;
        this.objectFormatter = objectFormatter;
        this.stateCacheEnabled = stateCacheEnabled;
        this.hasPropertyOptimized = hasPropertyOptimized;
        this.hasNodeOptimized = hasNodeOptimized;
        this.rootNodePath = rootNodePath;
        this.rootNodePathSegments = rootNodePathSegments;
        this.nodeInfoManager = new NodeInfoManager();
        this.queryManager = new QueryManager(rootNodePath);
        this.rootCreateMode = rootCreateMode;
    }

    public boolean isHasPropertyOptimized() {
        return this.hasPropertyOptimized;
    }

    public boolean isHasNodeOptimized() {
        return this.hasNodeOptimized;
    }

    public Instrumentor getInstrumentor() {
        return this.instrumentor;
    }

    public ObjectMapper getTypeMapper(String nodeTypeName) {
        return this.typeMapperByNodeType.get(nodeTypeName);
    }

    public ObjectMapper getTypeMapper(Class<?> clazz) {
        return this.typeMapperByClass.get(clazz);
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    String decodeName(EntityContext ctx, String internal, NameKind nameKind) throws RepositoryException {
        if (ctx == null) {
            throw new NullPointerException();
        }
        return this.decodeName(ctx.state.getNode(), internal, nameKind);
    }

    String decodeName(Node ownerNode, String internal, NameKind nameKind) throws RepositoryException {
        String external;
        if (ownerNode == null) {
            throw new NullPointerException();
        }
        if (nameKind == NameKind.PROPERTY) {
            return internal;
        }
        ObjectFormatter formatter = null;
        String nodeTypeName = ownerNode.getPrimaryNodeType().getName();
        ObjectMapper parentMapper = this.getTypeMapper(nodeTypeName);
        if (parentMapper != null) {
            formatter = parentMapper.getFormatter();
        }
        if (formatter == null) {
            formatter = this.objectFormatter;
        }
        try {
            if (nameKind != NameKind.OBJECT) {
                throw new UnsupportedOperationException();
            }
            external = formatter.decodeNodeName(null, internal);
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException) {
                throw (IllegalStateException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
        if (external == null && nameKind == NameKind.OBJECT) {
            throw new IllegalStateException();
        }
        return external;
    }

    String encodeName(EntityContext ownerCtx, String external, NameKind nameKind) {
        String internal;
        if (external == null) {
            throw new NullPointerException("No null name accepted");
        }
        if (nameKind == NameKind.PROPERTY) {
            return external;
        }
        ObjectFormatter formatter = null;
        if (ownerCtx != null) {
            formatter = ownerCtx.mapper.getFormatter();
        }
        if (formatter == null) {
            formatter = this.objectFormatter;
        }
        try {
            if (nameKind != NameKind.OBJECT) {
                throw new UnsupportedOperationException();
            }
            internal = formatter.encodeNodeName(null, external);
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                throw (NullPointerException)e;
            }
            if (e instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
        if (internal == null) {
            throw new IllegalArgumentException("Name " + external + " was converted to null");
        }
        Path.validateName((String)internal);
        return internal;
    }
}

