/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.chromattic.api.BuilderException;
import org.chromattic.api.Chromattic;
import org.chromattic.api.ChromatticBuilder;
import org.chromattic.api.format.ObjectFormatter;
import org.chromattic.common.ObjectInstantiator;
import org.chromattic.common.jcr.Path;
import org.chromattic.common.jcr.PathException;
import org.chromattic.core.Domain;
import org.chromattic.core.api.ChromatticImpl;
import org.chromattic.core.bean.BeanInfoFactory;
import org.chromattic.core.mapping.NodeTypeMapping;
import org.chromattic.core.mapping.TypeMappingBuilder;
import org.chromattic.spi.instrument.Instrumentor;
import org.chromattic.spi.jcr.SessionLifeCycle;
import org.reflext.api.ClassTypeInfo;
import org.reflext.core.TypeDomain;
import org.reflext.jlr.JavaLangReflectMethodModel;
import org.reflext.jlr.JavaLangReflectTypeModel;
import org.reflext.spi.model.MethodModel;
import org.reflext.spi.model.TypeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChromatticBuilderImpl
extends ChromatticBuilder {
    private <T> T create(ChromatticBuilder.Option.Instance<String> optionInstance, Class<T> expectedClass) {
        String s = (String)optionInstance.getValue();
        return (T)ObjectInstantiator.newInstance((String)s, expectedClass);
    }

    protected Chromattic boot(ChromatticBuilder.Options options, Set<Class> classes) throws BuilderException {
        boolean lazyCreateMode;
        String rootNodePath;
        HashMap types = new HashMap();
        BeanInfoFactory beanInfoBuilder = new BeanInfoFactory(types);
        TypeDomain typeDomain = new TypeDomain((TypeModel)new JavaLangReflectTypeModel(), (MethodModel)new JavaLangReflectMethodModel());
        TypeMappingBuilder mappingBuilder = new TypeMappingBuilder(beanInfoBuilder);
        HashSet<NodeTypeMapping> mappings = new HashSet<NodeTypeMapping>();
        for (Class clazz : classes) {
            ClassTypeInfo typeInfo = (ClassTypeInfo)typeDomain.getType((Object)clazz);
            NodeTypeMapping mapping = mappingBuilder.build(typeInfo);
            mappings.add(mapping);
        }
        Boolean optimizeJCREnabled = (Boolean)options.getValue(JCR_OPTIMIZE_ENABLED);
        boolean hasPropertyOptimized = optimizeJCREnabled != null ? optimizeJCREnabled.booleanValue() : ((Boolean)options.getValue(JCR_OPTIMIZE_HAS_PROPERTY_ENABLED)).booleanValue();
        boolean hasNodeOptimized = optimizeJCREnabled != null ? optimizeJCREnabled.booleanValue() : ((Boolean)options.getValue(JCR_OPTIMIZE_HAS_NODE_ENABLED)).booleanValue();
        boolean stateCacheEnabled = (Boolean)options.getValue(CACHE_STATE_ENABLED);
        try {
            rootNodePath = Path.normalizeAbsolutePath((String)((String)options.getValue(ROOT_NODE_PATH)));
        }
        catch (PathException e) {
            throw new BuilderException("Root node path must be valid");
        }
        boolean createRootNode = (Boolean)options.getValue(CREATE_ROOT_NODE);
        int rootCreateMode = createRootNode ? ((lazyCreateMode = ((Boolean)options.getValue(LAZY_CREATE_ROOT_NODE)).booleanValue()) ? Domain.LAZY_CREATE_MODE : Domain.CREATE_MODE) : Domain.NO_CREATE;
        Instrumentor instrumentor = this.create((ChromatticBuilder.Option.Instance<String>)options.getInstance(INSTRUMENTOR_CLASSNAME), Instrumentor.class);
        ObjectFormatter objectFormatter = this.create((ChromatticBuilder.Option.Instance<String>)options.getInstance(OBJECT_FORMATTER_CLASSNAME), ObjectFormatter.class);
        SessionLifeCycle sessionLifeCycle = this.create((ChromatticBuilder.Option.Instance<String>)options.getInstance(SESSION_LIFECYCLE_CLASSNAME), SessionLifeCycle.class);
        Domain domain = new Domain(mappings, instrumentor, objectFormatter, stateCacheEnabled, hasPropertyOptimized, hasNodeOptimized, rootNodePath, rootCreateMode);
        return new ChromatticImpl(domain, sessionLifeCycle);
    }
}

