/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.common.JCR;
import org.chromattic.common.collection.AbstractFilterIterator;
import org.chromattic.core.EntityContext;
import org.chromattic.core.vt.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyMap
extends AbstractMap<String, Object> {
    private final EntityContext ctx;
    private final SetImpl set = new SetImpl();

    public PropertyMap(EntityContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.set;
    }

    @Override
    public Object get(Object key) {
        if (key instanceof String) {
            return this.ctx.getPropertyValue((String)key, ValueType.DEFAULT);
        }
        return null;
    }

    @Override
    public Object remove(Object key) {
        if (key instanceof String) {
            return this.put((String)key, (Object)null);
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        Object previous = this.ctx.getPropertyValue(key, ValueType.DEFAULT);
        this.ctx.setPropertyValue(key, ValueType.DEFAULT, value);
        return previous;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetImpl
    extends AbstractSet<Map.Entry<String, Object>> {
        private SetImpl() {
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            try {
                Iterator i = JCR.adapt((PropertyIterator)((PropertyMap)PropertyMap.this).ctx.state.getNode().getProperties());
                return new AbstractFilterIterator<Map.Entry<String, Object>, Property>(i){

                    protected Map.Entry<String, Object> adapt(Property internal) {
                        try {
                            final String key = internal.getName();
                            switch (internal.getType()) {
                                case 1: 
                                case 3: 
                                case 6: 
                                case 7: {
                                    return new Map.Entry<String, Object>(){

                                        @Override
                                        public String getKey() {
                                            return key;
                                        }

                                        @Override
                                        public Object getValue() {
                                            return PropertyMap.this.ctx.getPropertyValue(key, ValueType.DEFAULT);
                                        }

                                        @Override
                                        public Object setValue(Object value) {
                                            throw new UnsupportedOperationException();
                                        }
                                    };
                                }
                            }
                            return null;
                        }
                        catch (RepositoryException e) {
                            throw new UndeclaredRepositoryException(e);
                        }
                    }
                };
            }
            catch (RepositoryException e) {
                throw new UndeclaredRepositoryException(e);
            }
        }

        @Override
        public int size() {
            int count = 0;
            Iterator<Map.Entry<String, Object>> iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
            return count;
        }
    }
}

