/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper.property;

import java.util.List;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.mapper.PropertyMapper;
import org.chromattic.core.vt.ValueType;
import org.chromattic.core.vt.ValueTypeFactory;
import org.chromattic.metamodel.bean.SimpleValueInfo;
import org.chromattic.metamodel.bean.SingleValuedPropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRPropertyPropertyMapper<O extends ObjectContext>
extends PropertyMapper<SingleValuedPropertyInfo<SimpleValueInfo>, O> {
    private final String jcrPropertyName;
    private final ValueType<O> vt;

    public JCRPropertyPropertyMapper(Class<O> contextType, SingleValuedPropertyInfo<SimpleValueInfo> info, String jcrPropertyName, List<O> defaultValue) {
        super(contextType, info);
        this.jcrPropertyName = jcrPropertyName;
        this.vt = ValueTypeFactory.create((SimpleValueInfo)info.getValue(), defaultValue);
    }

    @Override
    public Object get(O context) throws Throwable {
        return this.get(context, this.vt);
    }

    private <V> V get(O context, ValueType<V> d) throws Throwable {
        return ((ObjectContext)context).getPropertyValue(this.jcrPropertyName, d);
    }

    @Override
    public void set(O context, Object o) throws Throwable {
        this.set(context, this.vt, o);
    }

    private <V> void set(O context, ValueType<V> vt, Object o) throws Throwable {
        Class<V> javaType = vt.getObjectType();
        V v = javaType.cast(o);
        ((ObjectContext)context).setPropertyValue(this.jcrPropertyName, vt, v);
    }
}

