/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.chromattic.api.format.ObjectFormatter;
import org.chromattic.common.ObjectInstantiator;
import org.chromattic.common.collection.SetMap;
import org.chromattic.core.EmbeddedContext;
import org.chromattic.core.EntityContext;
import org.chromattic.core.ObjectContext;
import org.chromattic.core.mapper.MethodMapper;
import org.chromattic.core.mapper.ObjectMapper;
import org.chromattic.core.mapper.PropertyMapper;
import org.chromattic.core.mapper.nodeattribute.JCRNodeAttributePropertyMapper;
import org.chromattic.core.mapper.onetomany.hierarchical.AnyChildMultiValueMapper;
import org.chromattic.core.mapper.onetomany.hierarchical.JCRAnyChildCollectionPropertyMapper;
import org.chromattic.core.mapper.onetomany.hierarchical.JCRAnyChildParentPropertyMapper;
import org.chromattic.core.mapper.onetomany.reference.JCRNamedReferentPropertyMapper;
import org.chromattic.core.mapper.onetomany.reference.JCRReferentCollectionPropertyMapper;
import org.chromattic.core.mapper.onetoone.embedded.JCREmbeddedParentPropertyMapper;
import org.chromattic.core.mapper.onetoone.embedded.JCREmbeddedPropertyMapper;
import org.chromattic.core.mapper.onetoone.hierarchical.JCRNamedChildParentPropertyMapper;
import org.chromattic.core.mapper.onetoone.hierarchical.JCRNamedChildPropertyMapper;
import org.chromattic.core.mapper.property.JCRPropertyListPropertyMapper;
import org.chromattic.core.mapper.property.JCRPropertyMapPropertyMapper;
import org.chromattic.core.mapper.property.JCRPropertyPropertyMapper;
import org.chromattic.core.vt2.ValueTypeFactory;
import org.chromattic.metamodel.bean.MultiValuedPropertyInfo;
import org.chromattic.metamodel.bean.SimpleValueInfo;
import org.chromattic.metamodel.mapping.AttributeMapping;
import org.chromattic.metamodel.mapping.BeanMapping;
import org.chromattic.metamodel.mapping.CreateMapping;
import org.chromattic.metamodel.mapping.DestroyMapping;
import org.chromattic.metamodel.mapping.FindByIdMapping;
import org.chromattic.metamodel.mapping.MappingVisitor;
import org.chromattic.metamodel.mapping.NodeTypeKind;
import org.chromattic.metamodel.mapping.PropertiesMapping;
import org.chromattic.metamodel.mapping.RelationshipMapping;
import org.chromattic.metamodel.mapping.ValueMapping;
import org.chromattic.metamodel.type.SimpleTypeResolver;
import org.chromattic.spi.type.SimpleTypeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperBuilder {
    private final SimpleTypeResolver simpleTypeResolver;
    private final ValueTypeFactory valueTypeFactory;

    public MapperBuilder(SimpleTypeResolver simpleTypeResolver) {
        this.simpleTypeResolver = simpleTypeResolver;
        this.valueTypeFactory = new ValueTypeFactory(simpleTypeResolver);
    }

    public Collection<ObjectMapper<?>> build(Collection<BeanMapping> beanMappings) {
        Context ctx = new Context();
        ctx.start();
        for (BeanMapping beanMapping : beanMappings) {
            beanMapping.accept((MappingVisitor)ctx);
        }
        ctx.end();
        return ctx.beanMappers.values();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Context
    extends MappingVisitor {
        private BeanMapping beanMapping;
        private SetMap<BeanMapping, MethodMapper.Create> createMethods;
        private Map<BeanMapping, ObjectMapper<?>> beanMappers;
        private Class<? extends ObjectContext> contextType;
        Set<MethodMapper<?>> methodMappers;
        Set<PropertyMapper<?, ?, ?>> propertyMappers;

        private Context() {
        }

        public void start() {
            this.beanMappers = new HashMap();
            this.createMethods = new SetMap();
        }

        public void startBean(BeanMapping mapping) {
            this.beanMapping = mapping;
            this.contextType = mapping.getNodeTypeKind() == NodeTypeKind.PRIMARY ? EntityContext.class : EmbeddedContext.class;
            this.propertyMappers = new HashSet();
            this.methodMappers = new HashSet();
        }

        public void singleValueMapping(ValueMapping.Single mapping) {
            SimpleTypeProvider vt = MapperBuilder.this.valueTypeFactory.create(((SimpleValueInfo)mapping.getValue()).getDeclaredType(), mapping.getPropertyDefinition().getMetaType());
            JCRPropertyPropertyMapper mapper = new JCRPropertyPropertyMapper(this.contextType, vt, mapping);
            this.propertyMappers.add(mapper);
        }

        public void multiValueMapping(ValueMapping.Multi mapping) {
            SimpleTypeProvider vt = MapperBuilder.this.valueTypeFactory.create(((SimpleValueInfo)mapping.getValue()).getDeclaredType(), mapping.getPropertyDefinition().getMetaType());
            JCRPropertyListPropertyMapper mapper = new JCRPropertyListPropertyMapper(this.contextType, vt, mapping);
            this.propertyMappers.add(mapper);
        }

        public void oneToOneHierarchic(RelationshipMapping.OneToOne.Hierarchic mapping) {
            try {
                if (mapping.isOwner()) {
                    JCRNamedChildParentPropertyMapper<? extends ObjectContext> mapper = new JCRNamedChildParentPropertyMapper<ObjectContext>(this.contextType, mapping);
                    this.propertyMappers.add(mapper);
                } else {
                    JCRNamedChildPropertyMapper mapper = new JCRNamedChildPropertyMapper(mapping);
                    this.propertyMappers.add(mapper);
                }
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public void oneToManyHierarchic(RelationshipMapping.OneToMany.Hierarchic mapping) {
            AnyChildMultiValueMapper valueMapper;
            switch (((MultiValuedPropertyInfo)mapping.getProperty()).getKind()) {
                case MAP: {
                    valueMapper = new AnyChildMultiValueMapper.Map();
                    break;
                }
                case LIST: {
                    valueMapper = new AnyChildMultiValueMapper.List();
                    break;
                }
                case COLLECTION: {
                    valueMapper = new AnyChildMultiValueMapper.Collection();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            try {
                JCRAnyChildParentPropertyMapper<? extends ObjectContext> mapper = new JCRAnyChildParentPropertyMapper<ObjectContext>(this.contextType, mapping, valueMapper);
                this.propertyMappers.add(mapper);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public void manyToOneHierarchic(RelationshipMapping.ManyToOne.Hierarchic mapping) {
            try {
                JCRAnyChildCollectionPropertyMapper mapper = new JCRAnyChildCollectionPropertyMapper(mapping);
                this.propertyMappers.add(mapper);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public void oneToManyReference(RelationshipMapping.OneToMany.Reference mapping) {
            try {
                JCRReferentCollectionPropertyMapper mapper = new JCRReferentCollectionPropertyMapper(mapping);
                this.propertyMappers.add(mapper);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public void manyToOneReference(RelationshipMapping.ManyToOne.Reference mapping) {
            try {
                JCRNamedReferentPropertyMapper<? extends ObjectContext> mapper = new JCRNamedReferentPropertyMapper<ObjectContext>(this.contextType, mapping);
                this.propertyMappers.add(mapper);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public void oneToOneEmbedded(RelationshipMapping.OneToOne.Embedded mapping) {
            try {
                if (mapping.isOwner()) {
                    JCREmbeddedParentPropertyMapper mapper = new JCREmbeddedParentPropertyMapper(mapping);
                    this.propertyMappers.add(mapper);
                } else {
                    JCREmbeddedPropertyMapper mapper = new JCREmbeddedPropertyMapper(mapping);
                    this.propertyMappers.add(mapper);
                }
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public void propertiesMapping(PropertiesMapping<?> mapping) {
            JCRPropertyMapPropertyMapper mapper = new JCRPropertyMapPropertyMapper(this.contextType, mapping);
            this.propertyMappers.add(mapper);
        }

        public void attributeMapping(AttributeMapping mapping) {
            JCRNodeAttributePropertyMapper mapper = new JCRNodeAttributePropertyMapper(mapping);
            this.propertyMappers.add(mapper);
        }

        public void visit(CreateMapping mapping) {
            MethodMapper.Create mapper = new MethodMapper.Create(mapping.getMethod());
            this.methodMappers.add(mapper);
            this.createMethods.get((Object)mapping.getBeanMapping()).add(mapper);
        }

        public void visit(DestroyMapping mapping) {
            MethodMapper.Destroy mapper = new MethodMapper.Destroy(mapping.getMethod());
            this.methodMappers.add(mapper);
        }

        public void visit(FindByIdMapping mapping) {
            try {
                MethodMapper.FindById mapper = new MethodMapper.FindById(mapping.getMethod(), mapping.getType());
                this.methodMappers.add(mapper);
            }
            catch (ClassNotFoundException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        public void endBean() {
            ObjectMapper mapper;
            if (this.beanMapping.getNodeTypeKind() == NodeTypeKind.PRIMARY) {
                ObjectFormatter formatter = null;
                if (this.beanMapping.getFormatterClassType() != null) {
                    Class formatterClass = (Class)this.beanMapping.getFormatterClassType().unwrap();
                    formatter = (ObjectFormatter)ObjectInstantiator.newInstance((Class)formatterClass);
                }
                mapper = new ObjectMapper(this.beanMapping, this.beanMapping.isAbstract(), (Class)this.beanMapping.getBean().getClassType().unwrap(), this.propertyMappers, this.methodMappers, this.beanMapping.getOnDuplicate(), formatter, this.beanMapping.getNodeTypeName(), this.beanMapping.getNodeTypeKind());
            } else {
                mapper = new ObjectMapper(this.beanMapping, this.beanMapping.isAbstract(), (Class)this.beanMapping.getBean().getClassType().unwrap(), this.propertyMappers, this.methodMappers, this.beanMapping.getOnDuplicate(), null, this.beanMapping.getNodeTypeName(), this.beanMapping.getNodeTypeKind());
            }
            this.beanMappers.put(this.beanMapping, mapper);
        }

        public void end() {
            for (BeanMapping beanMapping : this.createMethods.keySet()) {
                ObjectMapper<?> beanMapper = this.beanMappers.get(beanMapping);
                for (MethodMapper.Create createMapper : this.createMethods.get((Object)beanMapping)) {
                    createMapper.mapper = beanMapper;
                }
            }
        }
    }
}

