/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper.onetomany.reference;

import java.util.EnumMap;
import org.chromattic.api.RelationshipType;
import org.chromattic.core.EntityContext;
import org.chromattic.core.jcr.LinkType;
import org.chromattic.core.mapper.JCRNodeCollectionPropertyMapper;
import org.chromattic.core.mapper.onetomany.reference.ReferentCollection;
import org.chromattic.metamodel.bean.BeanValueInfo;
import org.chromattic.metamodel.bean.PropertyInfo;
import org.chromattic.metamodel.bean.ValueKind;
import org.chromattic.metamodel.mapping.RelationshipMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRReferentCollectionPropertyMapper
extends JCRNodeCollectionPropertyMapper<PropertyInfo<BeanValueInfo, ValueKind.Collection>, EntityContext, ValueKind.Collection> {
    static final EnumMap<RelationshipType, LinkType> relationshipToLinkMapping;
    final String propertyName;
    final LinkType linkType;

    public JCRReferentCollectionPropertyMapper(RelationshipMapping.OneToMany.Reference<ValueKind.Collection> info) throws ClassNotFoundException {
        super(EntityContext.class, info);
        this.propertyName = info.getMappedBy();
        this.linkType = relationshipToLinkMapping.get(info.getType());
    }

    @Override
    public Object get(EntityContext context) throws Throwable {
        Object collection = context.getAttribute(this);
        if (collection == null) {
            collection = new ReferentCollection(context, this);
            context.setAttribute(this, collection);
        }
        return collection;
    }

    static {
        EnumMap<RelationshipType, LinkType> tmp = new EnumMap<RelationshipType, LinkType>(RelationshipType.class);
        tmp.put(RelationshipType.REFERENCE, LinkType.REFERENCE);
        tmp.put(RelationshipType.PATH, LinkType.PATH);
        relationshipToLinkMapping = tmp;
    }
}

