/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.mapper.property;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.chromattic.api.UndeclaredRepositoryException;
import org.chromattic.common.JCR;
import org.chromattic.common.collection.AbstractFilterIterator;
import org.chromattic.core.EntityContext;
import org.chromattic.core.ListType;
import org.chromattic.core.mapper.property.JCRPropertyDetypedPropertyMapper;
import org.chromattic.metamodel.bean.ValueKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyMap
extends AbstractMap<String, Object> {
    private final JCRPropertyDetypedPropertyMapper mapper;
    private final EntityContext ctx;
    private SetImpl set;

    PropertyMap(JCRPropertyDetypedPropertyMapper mapper, EntityContext ctx) {
        this.ctx = ctx;
        this.mapper = mapper;
        this.set = null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.set == null) {
            this.set = new SetImpl();
        }
        return this.set;
    }

    @Override
    public Object get(Object key) {
        String s = this.validateKey(key);
        if (s != null) {
            try {
                if (this.mapper.valueKind == ValueKind.SINGLE) {
                    return this.ctx.getPropertyValue(s, null);
                }
                return this.ctx.getPropertyValues(s, null, ListType.LIST);
            }
            catch (RepositoryException e) {
                throw new UndeclaredRepositoryException(e);
            }
        }
        return null;
    }

    @Override
    public Object remove(Object key) {
        String s = this.validateKey(key);
        if (s != null) {
            return this.put(s, (Object)null);
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        String s = this.validateKey(key);
        if (s != null) {
            return this.update(key, value);
        }
        throw new IllegalArgumentException("Invalid key " + key + " should being with the prefix " + this.mapper.namePrefix);
    }

    private String validateKey(Object key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        if (key instanceof String) {
            String s = (String)key;
            if (this.mapper.namePrefix != null) {
                return this.mapper.namePrefix + s;
            }
            return s;
        }
        throw new ClassCastException("Key must be instance of String instead of " + key.getClass().getName());
    }

    private Object update(String key, Object value) {
        try {
            Object previous;
            if (this.mapper.valueKind == ValueKind.SINGLE) {
                previous = this.ctx.getPropertyValue(key, null);
                this.ctx.setPropertyValue(key, null, value);
            } else {
                List list = (List)value;
                previous = this.ctx.getPropertyValues(key, null, ListType.LIST);
                this.ctx.setPropertyValues(key, null, ListType.LIST, list);
            }
            return previous;
        }
        catch (RepositoryException e) {
            throw new UndeclaredRepositoryException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetImpl
    extends AbstractSet<Map.Entry<String, Object>> {
        private SetImpl() {
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            try {
                Iterator i = ((PropertyMap)PropertyMap.this).mapper.namePattern == null ? JCR.adapt((PropertyIterator)PropertyMap.this.ctx.getNode().getProperties()) : JCR.adapt((PropertyIterator)PropertyMap.this.ctx.getNode().getProperties(((PropertyMap)PropertyMap.this).mapper.namePattern));
                return new AbstractFilterIterator<Map.Entry<String, Object>, Property>(i){

                    protected Map.Entry<String, Object> adapt(Property internal) {
                        try {
                            String name;
                            final String key = internal.getName();
                            String string = name = ((PropertyMap)PropertyMap.this).mapper.namePrefix != null ? key.substring(((PropertyMap)PropertyMap.this).mapper.namePrefix.length()) : key;
                            if ("*".equals(internal.getDefinition().getName())) {
                                switch (internal.getType()) {
                                    case 1: 
                                    case 3: 
                                    case 6: 
                                    case 7: {
                                        return new Map.Entry<String, Object>(){

                                            @Override
                                            public String getKey() {
                                                return name;
                                            }

                                            @Override
                                            public Object getValue() {
                                                return PropertyMap.this.get(key);
                                            }

                                            @Override
                                            public Object setValue(Object value) {
                                                throw new UnsupportedOperationException();
                                            }
                                        };
                                    }
                                }
                            }
                            return null;
                        }
                        catch (RepositoryException e) {
                            throw new UndeclaredRepositoryException(e);
                        }
                    }
                };
            }
            catch (RepositoryException e) {
                throw new UndeclaredRepositoryException(e);
            }
        }

        @Override
        public int size() {
            int count = 0;
            Iterator<Map.Entry<String, Object>> iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
            return count;
        }
    }
}

