/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.dataobject.runtime;

import javax.jcr.Node;
import javax.jcr.Session;
import org.chromattic.api.Chromattic;
import org.chromattic.api.ChromatticBuilder;
import org.chromattic.api.ChromatticException;
import org.chromattic.api.ChromatticSession;
import org.chromattic.api.Status;
import org.chromattic.api.event.EventListener;
import org.chromattic.api.query.QueryBuilder;
import org.chromattic.dataobject.runtime.ChromatticSessionProvider;
import org.exoplatform.services.security.ConversationState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataObjectChromatticSession
implements ChromatticSession {
    private final ChromatticSessionProvider provider;
    private ChromatticSession effective;
    ChromatticBuilder builder;
    private static final ThreadLocal<DataObjectChromatticSession> current = new ThreadLocal();

    DataObjectChromatticSession(ChromatticSessionProvider provider) {
        this.provider = provider;
    }

    private ChromatticSession safeGet() throws IllegalStateException {
        if (this.effective == null) {
            if (this.builder == null) {
                throw new IllegalStateException("Chromattic session proxy is currently not associated");
            }
            ConversationState cs = ConversationState.getCurrent();
            String userId = cs.getIdentity().getUserId();
            String rootNodePath = this.provider.rootNodePath + userId;
            String rootNodeType = this.provider.rootNodeType;
            ChromatticBuilder.Configuration config = new ChromatticBuilder.Configuration(this.builder.getConfiguration());
            config.setOptionValue(ChromatticBuilder.ROOT_NODE_PATH, (Object)rootNodePath, true);
            if (rootNodeType != null) {
                config.setOptionValue(ChromatticBuilder.ROOT_NODE_TYPE, (Object)rootNodeType, true);
            }
            Chromattic chromattic = this.builder.build(config);
            this.effective = chromattic.openSession();
            current.set(this);
        }
        return this.effective;
    }

    static void cleanup() {
        DataObjectChromatticSession proxy = current.get();
        if (current != null) {
            proxy.effective.close();
        }
    }

    public <O> O create(Class<O> clazz) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return (O)this.safeGet().create(clazz);
    }

    public <O> O create(Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return (O)this.safeGet().create(clazz, name);
    }

    public <O> O insert(Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return (O)this.safeGet().insert(clazz, name);
    }

    public <O> O insert(Object parent, Class<O> clazz, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return (O)this.safeGet().insert(parent, clazz, name);
    }

    public <O> O insert(Object parent, Class<O> clazz, String prefix, String localName) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return (O)this.safeGet().insert(parent, clazz, prefix, localName);
    }

    public <O> O insert(Class<O> clazz, String prefix, String localName) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return (O)this.safeGet().insert(clazz, prefix, localName);
    }

    public String persist(Object o, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return this.safeGet().persist(o, name);
    }

    public String persist(Object parent, Object child) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return this.safeGet().persist(parent, child);
    }

    public String persist(Object o) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return this.safeGet().persist(o);
    }

    public String persist(Object parent, Object o, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return this.safeGet().persist(parent, o, name);
    }

    public String persist(Object o, String prefix, String localName) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return this.safeGet().persist(o, prefix, localName);
    }

    public String persist(Object parent, Object o, String prefix, String localName) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return this.safeGet().persist(parent, o, prefix, localName);
    }

    public <O> O copy(Object parent, O o, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return (O)this.safeGet().copy(parent, o, name);
    }

    public <O> O copy(O o, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return (O)this.safeGet().copy(o, name);
    }

    public <O> O findByPath(Object origin, Class<O> clazz, String relPath) throws IllegalArgumentException, NullPointerException, ClassCastException, ChromatticException {
        return (O)this.safeGet().findByPath(origin, clazz, relPath);
    }

    public <O> O findByPath(Class<O> clazz, String relPath) throws NullPointerException, ClassCastException, ChromatticException {
        return (O)this.safeGet().findByPath(clazz, relPath);
    }

    public <O> O findByPath(Class<O> clazz, String path, boolean absolute) throws NullPointerException, ClassCastException, ChromatticException {
        return (O)this.safeGet().findByPath(clazz, path, absolute);
    }

    public <O> O findByNode(Class<O> clazz, Node node) throws NullPointerException, ClassCastException, ChromatticException {
        return (O)this.safeGet().findByNode(clazz, node);
    }

    public <O> O findById(Class<O> clazz, String id) throws NullPointerException, ClassCastException, ChromatticException {
        return (O)this.safeGet().findById(clazz, id);
    }

    public <O> QueryBuilder<O> createQueryBuilder(Class<O> fromClass) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return this.safeGet().createQueryBuilder(fromClass);
    }

    public void remove(Object o) throws NullPointerException, IllegalArgumentException, ChromatticException {
        this.safeGet().remove(o);
    }

    public Status getStatus(Object o) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return this.safeGet().getStatus(o);
    }

    public String getId(Object o) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return this.safeGet().getId(o);
    }

    public String getName(Object o) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return this.safeGet().getName(o);
    }

    public void setName(Object o, String name) throws NullPointerException, IllegalArgumentException, ChromatticException {
        this.safeGet().setName(o, name);
    }

    public String getPath(Object o) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return this.safeGet().getPath(o);
    }

    public <E> E getEmbedded(Object o, Class<E> embeddedType) throws NullPointerException, IllegalArgumentException, ChromatticException {
        return (E)this.safeGet().getEmbedded(o, embeddedType);
    }

    public <E> void setEmbedded(Object o, Class<E> embeddedType, E embedded) throws NullPointerException, IllegalArgumentException, ChromatticException {
        this.safeGet().setEmbedded(o, embeddedType, embedded);
    }

    public void addEventListener(EventListener listener) throws NullPointerException {
        this.safeGet().addEventListener(listener);
    }

    public void save() throws ChromatticException {
        this.safeGet().save();
    }

    public void close() {
        this.safeGet().close();
    }

    public boolean isClosed() {
        return this.safeGet().isClosed();
    }

    public Session getJCRSession() {
        return this.safeGet().getJCRSession();
    }
}

