/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.groovy;

import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.syntax.Token;

public class GroovyUtils {
    public static final String ANNOTATIONS_PACKAGE = "org.chromattic.";

    public static String getsetName(GetSet getSet, String fieldName) {
        return String.format("%s%s%s", getSet.toString().toLowerCase(), fieldName.substring(0, 1).toUpperCase(), fieldName.substring(1));
    }

    public static String fieldName(String getsetName) {
        if (!"get".equals(getsetName.substring(0, 3)) && !"set".equals(getsetName.substring(0, 3))) {
            throw new IllegalArgumentException("Invalid getter or setter name : " + getsetName);
        }
        return String.format("%s%s", getsetName.substring(3, 4).toLowerCase(), getsetName.substring(4));
    }

    public static void createGetter(ClassNode classNode, FieldNode fieldNode) {
        classNode.addMethod(GroovyUtils.getsetName(GetSet.GET, fieldNode.getName()), 1, fieldNode.getType(), new Parameter[0], new ClassNode[0], (Statement)new ReturnStatement((Expression)new FieldExpression(fieldNode)));
    }

    public static void createSetter(ClassNode classNode, FieldNode fieldNode) {
        classNode.addMethod(GroovyUtils.getsetName(GetSet.SET, fieldNode.getName()), 1, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(fieldNode.getType(), "value")}, new ClassNode[0], (Statement)new ExpressionStatement((Expression)new BinaryExpression((Expression)new PropertyExpression((Expression)new VariableExpression("this"), fieldNode.getName()), Token.newSymbol((int)100, (int)0, (int)0), (Expression)new VariableExpression("value"))));
    }

    public static MethodNode getGetter(ClassNode classNode, FieldNode fieldNode) {
        return classNode.getGetterMethod(GroovyUtils.getsetName(GetSet.GET, fieldNode.getName()));
    }

    public static MethodNode getSetter(ClassNode classNode, FieldNode fieldNode) {
        return classNode.getSetterMethod(GroovyUtils.getsetName(GetSet.SET, fieldNode.getName()));
    }

    public static boolean isChromatticAnnoted(FieldNode fieldNode) {
        for (AnnotationNode annotationNode : fieldNode.getAnnotations()) {
            if (!annotationNode.getClassNode().getName().startsWith(ANNOTATIONS_PACKAGE)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChromatticAnnoted(MethodNode methodNode) {
        if (methodNode == null) {
            return false;
        }
        for (AnnotationNode annotationNode : methodNode.getAnnotations()) {
            if (!annotationNode.getClassNode().getName().startsWith(ANNOTATIONS_PACKAGE)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChromatticAnnotedInHierarchy(ClassNode classNode, FieldNode fieldNode) {
        ClassNode superClassNode;
        if (classNode == null) {
            classNode = fieldNode.getDeclaringClass();
        }
        if (!(superClassNode = classNode.getSuperClass()).equals((Object)ClassHelper.OBJECT_TYPE)) {
            MethodNode superMethodNode = superClassNode.getMethod(GroovyUtils.getsetName(GetSet.GET, fieldNode.getName()), new Parameter[0]);
            if (superMethodNode != null) {
                return true;
            }
            GroovyUtils.isChromatticAnnotedInHierarchy(superClassNode, fieldNode);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GetSet {
        GET,
        SET;

    }
}

