/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.bean;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.chromattic.metamodel.bean.AnnotatedProperty;
import org.chromattic.metamodel.bean.PropertyInfo;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.introspection.AnnotationIntrospector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanInfo {
    private final ClassTypeInfo typeInfo;
    private final Map<String, PropertyInfo> properties;

    BeanInfo(ClassTypeInfo typeInfo, Map<String, PropertyInfo> properties) {
        this.typeInfo = typeInfo;
        this.properties = properties;
    }

    public Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Collection<PropertyInfo> getProperties() {
        return this.properties.values();
    }

    public ClassTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public PropertyInfo getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public <A extends Annotation> Collection<AnnotatedProperty<A>> findAnnotatedProperties(Class<A> annotationClass) {
        ArrayList<AnnotatedProperty<A>> matched = new ArrayList<AnnotatedProperty<A>>();
        for (PropertyInfo property : this.properties.values()) {
            AnnotatedProperty<A> propertyAnnotation = property.getAnnotated(annotationClass);
            if (propertyAnnotation == null) continue;
            matched.add(propertyAnnotation);
        }
        return matched;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException();
        }
        AnnotationIntrospector introspector = new AnnotationIntrospector(annotationClass);
        return (A)introspector.resolve(this.typeInfo);
    }
}

