/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.typegen.onetoone.hierarchical;

import java.util.Map;
import org.chromattic.common.collection.Collections;
import org.chromattic.metamodel.typegen.NodeType;
import org.chromattic.metamodel.typegen.TypeGen;
import org.chromattic.metamodel.typegen.TypeGenTestCase;
import org.chromattic.metamodel.typegen.onetoone.hierarchical.A1;
import org.chromattic.metamodel.typegen.onetoone.hierarchical.A2;
import org.chromattic.metamodel.typegen.onetoone.hierarchical.B1;
import org.chromattic.metamodel.typegen.onetoone.hierarchical.B2;
import org.chromattic.metamodel.typegen.onetoone.hierarchical.D;
import org.chromattic.metamodel.typegen.onetoone.hierarchical.E1;
import org.chromattic.metamodel.typegen.onetoone.hierarchical.E2;
import org.reflext.api.ClassTypeInfo;

public class SchemaTestCase
extends TypeGenTestCase {
    public void testMappedBy() throws Exception {
        Map<Class<?>, NodeType> a = this.assertValid(A1.class, A2.class);
        NodeType a1NT = a.get(A1.class);
        SchemaTestCase.assertEquals((String)"1", (String)a1NT.getName());
        NodeType a2NT = a.get(A2.class);
        SchemaTestCase.assertEquals((String)"2", (String)a2NT.getName());
        SchemaTestCase.assertEquals((Object)Collections.set((Object[])new String[]{"child"}), a1NT.getChildNodeDefinitions().keySet());
        SchemaTestCase.assertEquals((int)0, (int)a1NT.getPropertyDefinitions().size());
        SchemaTestCase.assertEquals((String)"2", (String)a1NT.getChildNodeDefinition("child").getNodeTypeName());
        SchemaTestCase.assertEquals((boolean)false, (boolean)a1NT.getChildNodeDefinition("child").isMandatory());
        SchemaTestCase.assertEquals((Object)Collections.set((Object[])new String[0]), a2NT.getChildNodeDefinitions().keySet());
        SchemaTestCase.assertEquals((int)0, (int)a2NT.getPropertyDefinitions().size());
    }

    public void testRelatedMappedBy() throws Exception {
        Map<Class<?>, NodeType> a = this.assertValid(B1.class, B2.class);
        NodeType b1NT = a.get(B1.class);
        SchemaTestCase.assertEquals((String)"1", (String)b1NT.getName());
        NodeType b2NT = a.get(B2.class);
        SchemaTestCase.assertEquals((String)"2", (String)b2NT.getName());
        SchemaTestCase.assertEquals((Object)Collections.set((Object[])new String[]{"child"}), b1NT.getChildNodeDefinitions().keySet());
        SchemaTestCase.assertEquals((int)0, (int)b1NT.getPropertyDefinitions().size());
        SchemaTestCase.assertEquals((String)"2", (String)b1NT.getChildNodeDefinition("child").getNodeTypeName());
        SchemaTestCase.assertEquals((boolean)false, (boolean)b1NT.getChildNodeDefinition("child").isMandatory());
        SchemaTestCase.assertEquals((int)0, (int)b2NT.getChildNodeDefinitions().size());
        SchemaTestCase.assertEquals((int)0, (int)b2NT.getPropertyDefinitions().size());
    }

    public void testOptions() throws Exception {
        Map<Class<?>, NodeType> a = this.assertValid(E1.class, E2.class);
        NodeType c1NT = a.get(E1.class);
        SchemaTestCase.assertEquals((String)"1", (String)c1NT.getName());
        NodeType c2NT = a.get(E2.class);
        SchemaTestCase.assertEquals((String)"2", (String)c2NT.getName());
        SchemaTestCase.assertEquals((Object)Collections.set((Object[])new String[0]), c1NT.getPropertyDefinitions().keySet());
        SchemaTestCase.assertEquals((Object)Collections.set((Object[])new String[]{"child1", "child2"}), c1NT.getChildNodeDefinitions().keySet());
        SchemaTestCase.assertEquals((String)"2", (String)c1NT.getChildNodeDefinition("child1").getNodeTypeName());
        SchemaTestCase.assertEquals((boolean)true, (boolean)c1NT.getChildNodeDefinition("child1").isMandatory());
        SchemaTestCase.assertEquals((boolean)false, (boolean)c1NT.getChildNodeDefinition("child1").isAutocreated());
        SchemaTestCase.assertEquals((String)"2", (String)c1NT.getChildNodeDefinition("child2").getNodeTypeName());
        SchemaTestCase.assertEquals((boolean)false, (boolean)c1NT.getChildNodeDefinition("child2").isMandatory());
        SchemaTestCase.assertEquals((boolean)true, (boolean)c1NT.getChildNodeDefinition("child2").isAutocreated());
        SchemaTestCase.assertEquals((Object)Collections.set((Object[])new String[0]), c2NT.getPropertyDefinitions().keySet());
        SchemaTestCase.assertEquals((Object)Collections.set((Object[])new String[0]), c2NT.getChildNodeDefinitions().keySet());
    }

    public void testSelf() throws Exception {
        TypeGen gen = new TypeGen();
        ClassTypeInfo c = gen.addType(D.class);
        gen.generate();
        NodeType cNT = gen.getNodeType(c);
        SchemaTestCase.assertEquals((String)"1", (String)cNT.getName());
        SchemaTestCase.assertEquals((Object)Collections.set((Object[])new String[]{"child"}), cNT.getChildNodeDefinitions().keySet());
        SchemaTestCase.assertEquals((int)0, (int)cNT.getPropertyDefinitions().size());
        SchemaTestCase.assertEquals((String)"1", (String)cNT.getChildNodeDefinition("child").getNodeTypeName());
        SchemaTestCase.assertEquals((boolean)false, (boolean)cNT.getChildNodeDefinition("child").isMandatory());
    }
}

