/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.bean;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.chromattic.common.collection.Collections;
import org.chromattic.metamodel.bean.AccessMode;
import org.chromattic.metamodel.bean.BeanInfo;
import org.chromattic.metamodel.bean.BeanInfoBuilder;
import org.chromattic.metamodel.bean.BeanTestCase;
import org.chromattic.metamodel.bean.BeanValueInfo;
import org.chromattic.metamodel.bean.ChromatticBeanTestCase;
import org.chromattic.metamodel.bean.PropertyInfo;
import org.chromattic.metamodel.bean.PropertyMetaData;
import org.chromattic.metamodel.bean.SimpleValueInfo;
import org.chromattic.metamodel.bean.ValueKind;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodSignature;
import org.reflext.api.TypeResolver;
import org.reflext.core.TypeResolverImpl;
import org.reflext.jlr.JavaLangReflectReflectionModel;
import org.reflext.spi.model.ReflectionModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChromatticBeanTestCase
extends BeanTestCase {
    protected TypeResolver<Type> domain;

    protected void setUp() throws Exception {
        this.domain = TypeResolverImpl.create((ReflectionModel)JavaLangReflectReflectionModel.getInstance());
    }

    protected void tearDown() throws Exception {
        this.domain = null;
    }

    @Override
    protected Collection<PropertyMetaData> buildMetaData(Class<?> beanClass) throws Exception {
        BeanInfoBuilder builder = new BeanInfoBuilder();
        ClassTypeInfo a = (ClassTypeInfo)this.domain.resolve(beanClass);
        BeanInfo bean = (BeanInfo)builder.build((Set)Collections.set((Object[])new ClassTypeInfo[]{a})).get(a);
        ArrayList<PropertyMetaData> res = new ArrayList<PropertyMetaData>();
        for (PropertyInfo pi : bean.getProperties().values()) {
            res.add(new PropertyMetaData(pi));
        }
        return res;
    }

    private Map<Class<?>, BeanInfo> buildInfo(Class<?> ... classes) throws Exception {
        BeanInfoBuilder builder = new BeanInfoBuilder();
        HashSet<ClassTypeInfo> classTypes = new HashSet<ClassTypeInfo>();
        for (Class<?> clazz : classes) {
            classTypes.add((ClassTypeInfo)this.domain.resolve(clazz));
        }
        Map classTypeToBean = builder.build(classTypes);
        HashMap classToBean = new HashMap();
        for (Map.Entry entry : classTypeToBean.entrySet()) {
            classToBean.put((Class)((ClassTypeInfo)entry.getKey()).unwrap(), (BeanInfo)entry.getValue());
        }
        return classToBean;
    }

    public void testDeadLock() throws Exception {
        class A {
            A() {
            }

            public 1A.B getB() {
                return null;
            }

            class 1A.B {
                1A.B() {
                }

                public A getA() {
                    return null;
                }
            }
        }
        this.assertProperties(1A.B.class, new PropertyMetaData("a", A.class, AccessMode.READ_ONLY));
    }

    public void testClassInheritance() throws Exception {
        class A {
            A() {
            }
        }
        class C
        extends 1B {
            C() {
                class B
                extends A {
                    final /* synthetic */ ChromatticBeanTestCase this$0;

                    B(ChromatticBeanTestCase chromatticBeanTestCase) {
                        this.this$0 = chromatticBeanTestCase;
                    }
                }
                super(ChromatticBeanTestCase.this);
            }
        }
        Map<Class<?>, BeanInfo> beans = this.buildInfo(A.class, C.class);
        BeanInfo ai = beans.get(A.class);
        BeanInfo ci = beans.get(C.class);
        ChromatticBeanTestCase.assertEquals((int)2, (int)beans.size());
        ChromatticBeanTestCase.assertNotNull((Object)ai);
        ChromatticBeanTestCase.assertNotNull((Object)ci);
        ChromatticBeanTestCase.assertSame(null, (Object)ai.getParent());
        ChromatticBeanTestCase.assertSame((Object)ai, (Object)ci.getParent());
    }

    public void testPropertyCovariantGetter() throws Exception {
        class A {
            A() {
            }

            public Object getA() {
                return null;
            }
        }
        class B
        extends A {
            B() {
            }

            public String getA() {
                return null;
            }
        }
        Map<Class<?>, BeanInfo> beans = this.buildInfo(A.class, B.class);
        BeanInfo ai = beans.get(A.class);
        BeanInfo bi = beans.get(B.class);
        PropertyInfo ap = ai.getProperty("a");
        PropertyInfo bp = bi.getProperty("a");
        ChromatticBeanTestCase.assertNotNull((Object)bp);
        ChromatticBeanTestCase.assertSame((Object)this.domain.resolve(String.class), (Object)bp.getValue().getDeclaredType());
        ChromatticBeanTestCase.assertSame((Object)ap, (Object)bp.getParent());
        ChromatticBeanTestCase.assertNotNull((Object)bp.getGetter());
        ChromatticBeanTestCase.assertSame((Object)bi.classType.getDeclaredMethod(new MethodSignature("getA", new Class[0])), (Object)bp.getGetter());
        ChromatticBeanTestCase.assertNull((Object)bp.getSetter());
    }

    public void testGenericProperty() throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class A<T extends Number> {
            A() {
            }

            public T getA() {
                return null;
            }
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class B
        extends A<Integer> {
            B() {
            }
        }
        Map<Class<?>, BeanInfo> beans = this.buildInfo(A.class, B.class);
        BeanInfo ai = beans.get(A.class);
        BeanInfo bi = beans.get(B.class);
        PropertyInfo ap = ai.getProperty("a");
        ChromatticBeanTestCase.assertNotNull((Object)ap);
        ChromatticBeanTestCase.assertNull((Object)ap.getParent());
        ChromatticBeanTestCase.assertNotNull((Object)ap.getGetter());
        ChromatticBeanTestCase.assertSame((Object)ai.classType.getDeclaredMethod(new MethodSignature("getA", new Class[0])), (Object)ap.getGetter());
        ChromatticBeanTestCase.assertNull((Object)ap.getSetter());
        PropertyInfo bp = bi.getProperty("a");
        ChromatticBeanTestCase.assertNotNull((Object)bp);
        ChromatticBeanTestCase.assertSame((Object)this.domain.resolve(Integer.class), (Object)bp.getValue().getEffectiveType());
        ChromatticBeanTestCase.assertSame((Object)ap, (Object)bp.getParent());
        ChromatticBeanTestCase.assertNotNull((Object)bp.getGetter());
        ChromatticBeanTestCase.assertSame((Object)ai.classType.getDeclaredMethod(new MethodSignature("getA", new Class[0])), (Object)bp.getGetter());
        ChromatticBeanTestCase.assertNull((Object)bp.getSetter());
    }

    public void testPropertySetterWithPropertyGetterTypeSubclass() throws Exception {
        class A {
            A() {
            }

            public Number getA() {
                return null;
            }

            public void setA(Integer a) {
            }
        }
        this.assertProperties(A.class, new PropertyMetaData("a", Number.class, AccessMode.READ_ONLY));
    }

    public void testBeanProperty() throws Exception {
        class A {
            A() {
            }
        }
        class B {
            B() {
            }

            public A getA() {
                return null;
            }
        }
        Map<Class<?>, BeanInfo> beans = this.buildInfo(A.class, B.class);
        BeanInfo ai = beans.get(A.class);
        BeanInfo bi = beans.get(B.class);
        PropertyInfo bp = bi.getProperty("a");
        ChromatticBeanTestCase.assertNotNull((Object)bp);
        ChromatticBeanTestCase.assertSame((Object)this.domain.resolve(A.class), (Object)bp.getValue().getDeclaredType());
        ChromatticBeanTestCase.assertSame((Object)this.domain.resolve(A.class), (Object)bp.getValue().getEffectiveType());
        ChromatticBeanTestCase.assertTrue((boolean)(bp.getValue() instanceof BeanValueInfo));
        ChromatticBeanTestCase.assertEquals((Object)ai, (Object)((BeanValueInfo)bp.getValue()).getBean());
        ChromatticBeanTestCase.assertSame(null, (Object)bp.getParent());
        ChromatticBeanTestCase.assertNotNull((Object)bp.getGetter());
        ChromatticBeanTestCase.assertSame((Object)bi.classType.getDeclaredMethod(new MethodSignature("getA", new Class[0])), (Object)bp.getGetter());
        ChromatticBeanTestCase.assertNull((Object)bp.getSetter());
    }

    public void testSelfBeanProperty() throws Exception {
        class A {
            A() {
            }

            public A getA() {
                return null;
            }
        }
        Map<Class<?>, BeanInfo> beans = this.buildInfo(A.class);
        BeanInfo ai = beans.get(A.class);
        PropertyInfo ap = ai.getProperty("a");
        ChromatticBeanTestCase.assertNotNull((Object)ap);
        ChromatticBeanTestCase.assertSame((Object)this.domain.resolve(A.class), (Object)ap.getValue().getDeclaredType());
        ChromatticBeanTestCase.assertSame((Object)this.domain.resolve(A.class), (Object)ap.getValue().getEffectiveType());
        ChromatticBeanTestCase.assertTrue((boolean)(ap.getValue() instanceof BeanValueInfo));
        ChromatticBeanTestCase.assertEquals((Object)ai, (Object)((BeanValueInfo)ap.getValue()).getBean());
        ChromatticBeanTestCase.assertSame(null, (Object)ap.getParent());
        ChromatticBeanTestCase.assertNotNull((Object)ap.getGetter());
        ChromatticBeanTestCase.assertSame((Object)ai.classType.getDeclaredMethod(new MethodSignature("getA", new Class[0])), (Object)ap.getGetter());
        ChromatticBeanTestCase.assertNull((Object)ap.getSetter());
    }

    public void testGenericSelfBeanProperty() throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class A<X> {
            A() {
            }

            public X getA() {
                return null;
            }
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class B
        extends A<B> {
            B() {
            }
        }
        Map<Class<?>, BeanInfo> beans = this.buildInfo(Object.class, A.class, B.class);
        BeanInfo oi = beans.get(Object.class);
        BeanInfo ai = beans.get(A.class);
        BeanInfo bi = beans.get(B.class);
        PropertyInfo ap = ai.getProperty("a");
        ChromatticBeanTestCase.assertNotNull((Object)ap);
        ChromatticBeanTestCase.assertSame(Object.class, (Object)ap.getValue().getEffectiveType().unwrap());
        ChromatticBeanTestCase.assertTrue((boolean)(ap.getValue() instanceof BeanValueInfo));
        ChromatticBeanTestCase.assertEquals((Object)oi, (Object)((BeanValueInfo)ap.getValue()).getBean());
        ChromatticBeanTestCase.assertSame(null, (Object)ap.getParent());
        ChromatticBeanTestCase.assertNotNull((Object)ap.getGetter());
        ChromatticBeanTestCase.assertSame((Object)ai.classType.getDeclaredMethod(new MethodSignature("getA", new Class[0])), (Object)ap.getGetter());
        ChromatticBeanTestCase.assertNull((Object)ap.getSetter());
        PropertyInfo bp = bi.getProperty("a");
        ChromatticBeanTestCase.assertNotNull((Object)bp);
        ChromatticBeanTestCase.assertSame((Object)this.domain.resolve(B.class), (Object)bp.getValue().getEffectiveType());
        ChromatticBeanTestCase.assertTrue((boolean)(bp.getValue() instanceof BeanValueInfo));
        ChromatticBeanTestCase.assertEquals((Object)bi, (Object)((BeanValueInfo)bp.getValue()).getBean());
        ChromatticBeanTestCase.assertSame((Object)ap, (Object)bp.getParent());
        ChromatticBeanTestCase.assertNotNull((Object)bp.getGetter());
        ChromatticBeanTestCase.assertSame((Object)ai.classType.getDeclaredMethod(new MethodSignature("getA", new Class[0])), (Object)bp.getGetter());
        ChromatticBeanTestCase.assertNull((Object)bp.getSetter());
    }

    public void testCollectionBeanProperty() throws Exception {
        class A {
            A() {
            }
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class B
        extends A {
            B() {
            }

            public Collection<A> getA() {
                return null;
            }
        }
        Map<Class<?>, BeanInfo> beans = this.buildInfo(A.class, B.class);
        BeanInfo ai = beans.get(A.class);
        BeanInfo bi = beans.get(B.class);
        PropertyInfo bp = bi.getProperty("a");
        ChromatticBeanTestCase.assertNotNull((Object)bp);
        ChromatticBeanTestCase.assertEquals((Object)ValueKind.COLLECTION, (Object)bp.getValueKind());
        ChromatticBeanTestCase.assertTrue((boolean)(bp.getValue() instanceof BeanValueInfo));
        ChromatticBeanTestCase.assertEquals((Object)ai, (Object)((BeanValueInfo)bp.getValue()).getBean());
        ChromatticBeanTestCase.assertSame(null, (Object)bp.getParent());
        ChromatticBeanTestCase.assertNotNull((Object)bp.getGetter());
        ChromatticBeanTestCase.assertSame((Object)bi.classType.getDeclaredMethod(new MethodSignature("getA", new Class[0])), (Object)bp.getGetter());
        ChromatticBeanTestCase.assertNull((Object)bp.getSetter());
    }

    public void testVariableResolveToBeanCollectionProperty() throws Exception {
        class A {
            A() {
            }
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class B<X> {
            B() {
            }

            public Collection<X> getA() {
                return null;
            }
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class C
        extends B<A> {
            C() {
            }
        }
        Map<Class<?>, BeanInfo> beans = this.buildInfo(Object.class, A.class, B.class, C.class);
        BeanInfo oi = beans.get(Object.class);
        BeanInfo ai = beans.get(A.class);
        BeanInfo bi = beans.get(B.class);
        BeanInfo ci = beans.get(C.class);
        PropertyInfo cp = ci.getProperty("a");
        ChromatticBeanTestCase.assertNotNull((Object)cp);
        ChromatticBeanTestCase.assertEquals((Object)ValueKind.COLLECTION, (Object)cp.getValueKind());
        ChromatticBeanTestCase.assertTrue((boolean)(cp.getValue() instanceof BeanValueInfo));
        ChromatticBeanTestCase.assertEquals((Object)ai, (Object)((BeanValueInfo)cp.getValue()).getBean());
    }

    public void testSimplePropertyList() throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class A {
            A() {
            }

            public List<String> getA() {
                return null;
            }
        }
        Map<Class<?>, BeanInfo> beans = this.buildInfo(A.class);
        BeanInfo ai = beans.get(A.class);
        PropertyInfo cp = ai.getProperty("a");
        ChromatticBeanTestCase.assertEquals((Object)ValueKind.SINGLE, (Object)cp.getValueKind());
        SimpleValueInfo value = (SimpleValueInfo)cp.getValue();
        ChromatticBeanTestCase.assertEquals((Object)ValueKind.LIST, (Object)value.getValueKind());
        ChromatticBeanTestCase.assertEquals((Object)this.domain.resolve(String.class), (Object)value.getDeclaredType());
    }

    public void testSimplePropertyArray() throws Exception {
        class A {
            A() {
            }

            public String[] getA() {
                return null;
            }
        }
        Map<Class<?>, BeanInfo> beans = this.buildInfo(A.class);
        BeanInfo ai = beans.get(A.class);
        PropertyInfo cp = ai.getProperty("a");
        ChromatticBeanTestCase.assertEquals((Object)ValueKind.SINGLE, (Object)cp.getValueKind());
        SimpleValueInfo value = (SimpleValueInfo)cp.getValue();
        ChromatticBeanTestCase.assertEquals((Object)ValueKind.ARRAY, (Object)value.getValueKind());
        ChromatticBeanTestCase.assertEquals((Object)this.domain.resolve(String.class), (Object)value.getDeclaredType());
    }

    public void testPropertyMap() throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class A {
            A() {
            }

            public Map<String, ?> getA() {
                return null;
            }
        }
        Map<Class<?>, BeanInfo> beans = this.buildInfo(A.class);
        BeanInfo ai = beans.get(A.class);
        PropertyInfo cp = ai.getProperty("a");
        ChromatticBeanTestCase.assertEquals((Object)ValueKind.MAP, (Object)cp.getValueKind());
        SimpleValueInfo value = (SimpleValueInfo)cp.getValue();
        ChromatticBeanTestCase.assertEquals((Object)ValueKind.SINGLE, (Object)value.getValueKind());
    }
}

