/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.bean;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import org.chromattic.metamodel.bean.AccessMode;
import org.chromattic.metamodel.bean.BeanTestCase;
import org.chromattic.metamodel.bean.PropertyMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanTestCase
extends BeanTestCase {
    @Override
    protected Collection<PropertyMetaData> buildMetaData(Class<?> beanClass) throws Exception {
        BeanInfo info = Introspector.getBeanInfo(beanClass, Object.class);
        ArrayList<PropertyMetaData> res = new ArrayList<PropertyMetaData>();
        for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
            res.add(new PropertyMetaData(pd));
        }
        return res;
    }

    public void testCovariantReturnTypeSubclass() throws Exception {
        class B
        extends 1A {
            B() {
                class A {
                    A() {
                    }

                    public Object getA() {
                        return null;
                    }
                }
            }

            public String getA() {
                return null;
            }
        }
        this.assertProperties(B.class, new PropertyMetaData("a", Object.class, AccessMode.READ_ONLY));
    }

    public void testGeneric() throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class A<T extends Number> {
            A() {
            }

            public T getA() {
                return null;
            }
        }
        this.assertProperties(A.class, new PropertyMetaData("a", Number.class, AccessMode.READ_ONLY));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class B
        extends A<Integer> {
            B() {
            }
        }
        this.assertProperties(B.class, new PropertyMetaData("a", Number.class, AccessMode.READ_ONLY));
    }
}

