/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.typegen.property;

import java.util.Arrays;
import java.util.Map;
import org.chromattic.metamodel.bean.SimpleValueInfo;
import org.chromattic.metamodel.bean.ValueKind;
import org.chromattic.metamodel.mapping.BeanMapping;
import org.chromattic.metamodel.mapping.PropertiesMapping;
import org.chromattic.metamodel.mapping.PropertyMapping;
import org.chromattic.metamodel.mapping.ValueMapping;
import org.chromattic.metamodel.mapping.jcr.PropertyDefinitionMapping;
import org.chromattic.metamodel.mapping.jcr.PropertyMetaType;
import org.chromattic.metamodel.typegen.AbstractMappingTestCase;
import org.chromattic.metamodel.typegen.property.A1;
import org.chromattic.metamodel.typegen.property.A2;
import org.chromattic.metamodel.typegen.property.B1;
import org.chromattic.metamodel.typegen.property.B2;
import org.chromattic.metamodel.typegen.property.C1;
import org.chromattic.metamodel.typegen.property.C2;
import org.chromattic.metamodel.typegen.property.D1;
import org.chromattic.metamodel.typegen.property.D2;
import org.chromattic.metamodel.typegen.property.E;

public class MappingTestCase
extends AbstractMappingTestCase {
    public void testA1() throws Exception {
        Map<Class<?>, BeanMapping> mappings = this.assertValid(A1.class);
        BeanMapping mapping = mappings.get(A1.class);
        ValueMapping stringMapping = (ValueMapping)mapping.getPropertyMapping("string", ValueMapping.class);
        MappingTestCase.assertEquals((Object)ValueKind.SINGLE, (Object)stringMapping.getProperty().getValueKind());
        PropertyDefinitionMapping propertyDefinition = stringMapping.getPropertyDefinition();
        MappingTestCase.assertEquals((String)"string", (String)propertyDefinition.getName());
        MappingTestCase.assertEquals(null, (Object)propertyDefinition.getDefaultValue());
        MappingTestCase.assertEquals((Object)PropertyMetaType.STRING, (Object)propertyDefinition.getMetaType());
        MappingTestCase.assertEquals((String)"string", (String)stringMapping.getName());
    }

    public void testA2() throws Exception {
        Map<Class<?>, BeanMapping> mappings = this.assertValid(A2.class);
        BeanMapping mapping = mappings.get(A2.class);
        ValueMapping stringMapping = (ValueMapping)mapping.getPropertyMapping("string", ValueMapping.class);
        MappingTestCase.assertEquals((Object)ValueKind.SINGLE, (Object)stringMapping.getProperty().getValueKind());
        PropertyDefinitionMapping propertyDefinition = stringMapping.getPropertyDefinition();
        MappingTestCase.assertEquals((String)"string", (String)propertyDefinition.getName());
        MappingTestCase.assertEquals(Arrays.asList("foo"), (Object)propertyDefinition.getDefaultValue());
        MappingTestCase.assertEquals((Object)PropertyMetaType.STRING, (Object)propertyDefinition.getMetaType());
        MappingTestCase.assertEquals((String)"string", (String)stringMapping.getName());
    }

    public void testB1() throws Exception {
        Map<Class<?>, BeanMapping> mappings = this.assertValid(B1.class);
        BeanMapping mapping = mappings.get(B1.class);
        ValueMapping stringMapping = (ValueMapping)mapping.getPropertyMapping("strings", ValueMapping.class);
        MappingTestCase.assertEquals((Object)ValueKind.SINGLE, (Object)stringMapping.getProperty().getValueKind());
        MappingTestCase.assertEquals((Object)ValueKind.LIST, (Object)((SimpleValueInfo)stringMapping.getValue()).getValueKind());
        PropertyDefinitionMapping propertyDefinition = stringMapping.getPropertyDefinition();
        MappingTestCase.assertEquals((String)"strings", (String)propertyDefinition.getName());
        MappingTestCase.assertEquals(null, (Object)propertyDefinition.getDefaultValue());
        MappingTestCase.assertEquals((Object)PropertyMetaType.STRING, (Object)propertyDefinition.getMetaType());
        MappingTestCase.assertEquals((String)"strings", (String)stringMapping.getName());
    }

    public void testB2() throws Exception {
        Map<Class<?>, BeanMapping> mappings = this.assertValid(B2.class);
        BeanMapping mapping = mappings.get(B2.class);
        ValueMapping stringMapping = (ValueMapping)mapping.getPropertyMapping("strings", ValueMapping.class);
        MappingTestCase.assertEquals((Object)ValueKind.SINGLE, (Object)stringMapping.getProperty().getValueKind());
        MappingTestCase.assertEquals((Object)ValueKind.LIST, (Object)((SimpleValueInfo)stringMapping.getValue()).getValueKind());
        PropertyDefinitionMapping propertyDefinition = stringMapping.getPropertyDefinition();
        MappingTestCase.assertEquals((String)"strings", (String)propertyDefinition.getName());
        MappingTestCase.assertEquals(Arrays.asList("foo", "bar"), (Object)propertyDefinition.getDefaultValue());
        MappingTestCase.assertEquals((Object)PropertyMetaType.STRING, (Object)propertyDefinition.getMetaType());
        MappingTestCase.assertEquals((String)"strings", (String)stringMapping.getName());
    }

    public void testC1() throws Exception {
        Map<Class<?>, BeanMapping> mappings = this.assertValid(C1.class);
        BeanMapping mapping = mappings.get(C1.class);
        ValueMapping stringMapping = (ValueMapping)mapping.getPropertyMapping("strings", ValueMapping.class);
        MappingTestCase.assertEquals((Object)ValueKind.SINGLE, (Object)stringMapping.getProperty().getValueKind());
        MappingTestCase.assertEquals((Object)ValueKind.ARRAY, (Object)((SimpleValueInfo)stringMapping.getValue()).getValueKind());
        PropertyDefinitionMapping propertyDefinition = stringMapping.getPropertyDefinition();
        MappingTestCase.assertEquals((String)"strings", (String)propertyDefinition.getName());
        MappingTestCase.assertEquals(null, (Object)propertyDefinition.getDefaultValue());
        MappingTestCase.assertEquals((Object)PropertyMetaType.STRING, (Object)propertyDefinition.getMetaType());
        MappingTestCase.assertEquals((String)"strings", (String)stringMapping.getName());
    }

    public void testC2() throws Exception {
        Map<Class<?>, BeanMapping> mappings = this.assertValid(C2.class);
        BeanMapping mapping = mappings.get(C2.class);
        ValueMapping stringMapping = (ValueMapping)mapping.getPropertyMapping("strings", ValueMapping.class);
        MappingTestCase.assertEquals((Object)ValueKind.SINGLE, (Object)stringMapping.getProperty().getValueKind());
        MappingTestCase.assertEquals((Object)ValueKind.ARRAY, (Object)((SimpleValueInfo)stringMapping.getValue()).getValueKind());
        PropertyDefinitionMapping propertyDefinition = stringMapping.getPropertyDefinition();
        MappingTestCase.assertEquals((String)"strings", (String)propertyDefinition.getName());
        MappingTestCase.assertEquals(Arrays.asList("foo", "bar"), (Object)propertyDefinition.getDefaultValue());
        MappingTestCase.assertEquals((Object)PropertyMetaType.STRING, (Object)propertyDefinition.getMetaType());
        MappingTestCase.assertEquals((String)"strings", (String)stringMapping.getName());
    }

    public void testD1() throws Exception {
        Map<Class<?>, BeanMapping> mappings = this.assertValid(D1.class);
        BeanMapping mapping = mappings.get(D1.class);
        PropertiesMapping stringMapping = (PropertiesMapping)mapping.getPropertyMapping("properties", PropertiesMapping.class);
        MappingTestCase.assertEquals((Object)ValueKind.MAP, (Object)stringMapping.getProperty().getValueKind());
        MappingTestCase.assertEquals((String)Object.class.getName(), (String)stringMapping.getProperty().getValue().getEffectiveType().getName());
    }

    public void testD2() throws Exception {
        Map<Class<?>, BeanMapping> mappings = this.assertValid(D2.class);
        BeanMapping mapping = mappings.get(D2.class);
        PropertiesMapping stringMapping = (PropertiesMapping)mapping.getPropertyMapping("properties", PropertiesMapping.class);
        MappingTestCase.assertEquals((Object)ValueKind.MAP, (Object)stringMapping.getProperty().getValueKind());
        MappingTestCase.assertEquals((String)String.class.getName(), (String)stringMapping.getProperty().getValue().getEffectiveType().getName());
    }

    public void testE() throws Exception {
        Map<Class<?>, BeanMapping> mappings = this.assertValid(E.class);
        BeanMapping mapping = mappings.get(E.class);
        PropertyMapping stringMapping = mapping.getPropertyMapping("bytes", PropertyMapping.class);
    }
}

