/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.testgenerator;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.chromattic.testgenerator.TestGeneratorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceUtil {
    public static List<String> getChromatticPaths(Element classElement) {
        ArrayList<String> paths = new ArrayList<String>();
        List annotationValues = (List)SourceUtil.getUniversalTestConfig(classElement, "chromatticClasses");
        for (AnnotationValue currentClass : annotationValues) {
            paths.add(SourceUtil.classnameToPath(((Object)currentClass).toString()));
        }
        return paths;
    }

    public static String getTestPath(Element classElement) {
        return SourceUtil.classnameToPath(SourceUtil.getUniversalTestConfig(classElement, "sourceClass").toString() + ".class");
    }

    public static <T> T getUniversalTestConfig(Element classElement, String key) {
        for (AnnotationMirror annotationMirror : classElement.getAnnotationMirrors()) {
            for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                if (!key.equals(executableElement.getSimpleName().toString())) continue;
                return (T)annotationMirror.getElementValues().get(executableElement).getValue();
            }
        }
        throw new TestGeneratorException("Configuration key not found [@UniversalTest." + key + "()] for " + classElement.getSimpleName());
    }

    public static String classnameToPath(String classname) {
        return classname.replaceAll("\\.", "/").replaceAll("/class$", ".java");
    }

    public static String groovyPath(String javaPath) {
        return javaPath.replaceAll("\\.java", ".groovy");
    }

    public static String sourceBaseDirectory(Element classElement) {
        return (String)SourceUtil.getUniversalTestConfig(classElement, "baseDir");
    }

    public static List<String> excludedMethods(Element classElement) {
        ArrayList<String> excludedMethods = new ArrayList<String>();
        List annotationValues = (List)SourceUtil.getUniversalTestConfig(classElement, "exclude");
        for (AnnotationValue currentExcluded : annotationValues) {
            excludedMethods.add((String)currentExcluded.getValue());
        }
        return excludedMethods;
    }

    public static String suffixOf(Element classElement) {
        return (String)SourceUtil.getUniversalTestConfig(classElement, "suffix");
    }

    public static void writeSource(String code, OutputStream os) {
        PrintWriter printWriter = new PrintWriter(os);
        printWriter.append(code);
        printWriter.flush();
        printWriter.close();
    }
}

