/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.testgenerator.sourcetransformer;

import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.expr.AnnotationExpr;
import japa.parser.ast.expr.ArrayCreationExpr;
import japa.parser.ast.expr.MethodCallExpr;
import japa.parser.ast.visitor.VoidVisitorAdapter;
import java.util.ArrayList;
import java.util.List;
import org.chromattic.testgenerator.sourcetransformer.TransformationSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitTestVisitor
extends VoidVisitorAdapter<List<String>>
implements TransformationSource {
    private List<AnnotationExpr> annotationExprs = new ArrayList<AnnotationExpr>();
    private List<MethodCallExpr> methodCallExprs = new ArrayList<MethodCallExpr>();
    private String suffix;

    public UnitTestVisitor(String suffix) {
        this.suffix = suffix;
    }

    public void visit(ClassOrInterfaceDeclaration n, List<String> excludedMethods) {
        ArrayList<MethodDeclaration> methodToRemove = new ArrayList<MethodDeclaration>();
        for (BodyDeclaration bodyDeclaration : n.getMembers()) {
            MethodDeclaration methodDeclaration;
            if (!(bodyDeclaration instanceof MethodDeclaration) || !excludedMethods.contains((methodDeclaration = (MethodDeclaration)bodyDeclaration).getName())) continue;
            methodToRemove.add(methodDeclaration);
        }
        n.getMembers().removeAll(methodToRemove);
        if (n.getAnnotations() != null) {
            this.annotationExprs.addAll(n.getAnnotations());
        }
        n.setName(n.getName() + this.suffix);
        super.visit(n, excludedMethods);
    }

    public void visit(MethodDeclaration n, List<String> arg) {
        if (n.getAnnotations() != null) {
            this.annotationExprs.addAll(n.getAnnotations());
        }
        super.visit(n, arg);
    }

    public void visit(MethodCallExpr n, List<String> arg) {
        this.methodCallExprs.add(n);
        super.visit(n, arg);
    }

    public void visit(ArrayCreationExpr n, List<String> arg) {
        super.visit(n, arg);
    }

    @Override
    public List<AnnotationExpr> getAnnotationExprs() {
        return this.annotationExprs;
    }

    @Override
    public List<MethodCallExpr> getMethodCallExprs() {
        return this.methodCallExprs;
    }
}

