/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.testgenerator;

import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.ast.CompilationUnit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.StandardLocation;
import org.chromattic.testgenerator.SourceUtil;
import org.chromattic.testgenerator.TestGeneratorException;
import org.chromattic.testgenerator.UniversalTest;
import org.chromattic.testgenerator.sourcetransformer.GroovyFromJavaSourceChromatticBuilder;
import org.chromattic.testgenerator.sourcetransformer.GroovyFromJavaSourceTestBuilder;
import org.chromattic.testgenerator.sourcetransformer.JavaToGroovyPropertiesSyntaxTransformer;
import org.chromattic.testgenerator.sourcetransformer.JavaToGroovySyntaxTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_5)
@SupportedAnnotationTypes(value={"org.chromattic.testgenerator.UniversalTest"})
public class TestGeneratorProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(UniversalTest.class)) {
            List<String> excludedMethods;
            String suffix = SourceUtil.suffixOf(element);
            String sourceBase = String.format("%s/src/test/java/", SourceUtil.sourceBaseDirectory(element));
            String testCompletSourcePath = sourceBase + SourceUtil.getTestPath(element);
            try {
                excludedMethods = SourceUtil.excludedMethods(element);
            }
            catch (TestGeneratorException tge) {
                excludedMethods = new ArrayList<String>();
            }
            String testGroovyPath = SourceUtil.groovyPath(testCompletSourcePath).replace(sourceBase, "").replaceAll("\\.groovy", "_" + suffix + ".groovy");
            String testPropertiesGroovyPath = SourceUtil.groovyPath(testCompletSourcePath).replace(sourceBase, "").replaceAll("\\.groovy", "_Property_" + suffix + ".groovy");
            try {
                InputStream testIs = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", testCompletSourcePath).openInputStream();
                CompilationUnit testUnit = JavaParser.parse((InputStream)testIs);
                OutputStream testOs = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", testGroovyPath, element).openOutputStream();
                GroovyFromJavaSourceTestBuilder testBuilder = new GroovyFromJavaSourceTestBuilder(testUnit, suffix);
                testBuilder.build(new JavaToGroovySyntaxTransformer(), excludedMethods);
                SourceUtil.writeSource(testBuilder.toString(), testOs);
                InputStream testPropertiesIs = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", testCompletSourcePath).openInputStream();
                CompilationUnit testPropertiesUnit = JavaParser.parse((InputStream)testPropertiesIs);
                OutputStream testPropertiesOs = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", testPropertiesGroovyPath, element).openOutputStream();
                GroovyFromJavaSourceTestBuilder testPropertiesBuilder = new GroovyFromJavaSourceTestBuilder(testPropertiesUnit, "Property_" + suffix);
                testPropertiesBuilder.build(new JavaToGroovyPropertiesSyntaxTransformer(), excludedMethods);
                SourceUtil.writeSource(testPropertiesBuilder.toString(), testPropertiesOs);
                for (String chromatticSourcePath : SourceUtil.getChromatticPaths(element)) {
                    String chromatticCompletSourcePath = sourceBase + chromatticSourcePath;
                    String chromatticGroovyPath = SourceUtil.groovyPath(chromatticSourcePath);
                    InputStream chromatticIs = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", chromatticCompletSourcePath).openInputStream();
                    CompilationUnit chromatticUnit = JavaParser.parse((InputStream)chromatticIs);
                    try {
                        OutputStream chromatticOs = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "", chromatticGroovyPath, element).openOutputStream();
                        GroovyFromJavaSourceChromatticBuilder chromatticBuilder = new GroovyFromJavaSourceChromatticBuilder(chromatticUnit);
                        chromatticBuilder.build();
                        SourceUtil.writeSource(chromatticBuilder.toString(), chromatticOs);
                    }
                    catch (FilerException ignore) {}
                }
            }
            catch (IOException e) {
                throw new TestGeneratorException(e.getMessage(), e);
            }
            catch (ParseException e) {
                throw new TestGeneratorException(e.getMessage(), e);
            }
        }
        return true;
    }
}

