/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.testgenerator;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.chromattic.testgenerator.GroovyOutputFormat;
import org.chromattic.testgenerator.GroovyTestGeneration;
import org.chromattic.testgenerator.SourceUtil;
import org.chromattic.testgenerator.TestId;
import org.chromattic.testgenerator.TestRef;
import org.chromattic.testgenerator.TestSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_5)
@SupportedAnnotationTypes(value={"org.chromattic.testgenerator.GroovyTestGeneration", "org.chromattic.testgenerator.TestId"})
public class CheckTestProcessor
extends AbstractProcessor {
    private final Set<TestRef> generatedTests = new HashSet<TestRef>();
    private TestId testId;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        Set<? extends Element> elements = roundEnvironment.getElementsAnnotatedWith(TestId.class);
        if (elements.size() != 0) {
            this.testId = elements.iterator().next().getAnnotation(TestId.class);
        }
        for (Element element : roundEnvironment.getElementsAnnotatedWith(GroovyTestGeneration.class)) {
            TypeElement typeElt = (TypeElement)element;
            TestRef ref = new TestRef(typeElt.getQualifiedName().toString());
            List<String> chromatticClassNames = SourceUtil.getChromatticClassName(typeElt);
            for (String chromatticQualifiedClassName : chromatticClassNames) {
                String chromatticName = GroovyOutputFormat.CHROMATTIC.getPackageName(chromatticQualifiedClassName) + "." + ((Object)GroovyOutputFormat.CHROMATTIC.getClassName(chromatticQualifiedClassName)).toString();
                ref.getChromatticObject().add(chromatticName);
            }
            this.generatedTests.add(ref);
        }
        if (roundEnvironment.processingOver()) {
            try {
                String name = "testsRef-" + this.testId.value() + ".xml";
                FileObject fileObject = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, "load", name, new Element[0]);
                Writer xmlWriter = fileObject.openWriter();
                TestSerializer xmlSerializer = new TestSerializer();
                xmlSerializer.writeTo(xmlWriter, this.generatedTests);
                xmlWriter.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }
}

