/*
 * Decompiled with CFR 0.152.
 */
package grizzled.net;

import grizzled.file.util$;
import grizzled.io.Implicits$;
import grizzled.net.URL;
import grizzled.net.URL$;
import grizzled.util.package$Implicits$;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;
import scala.util.matching.Regex;

public final class URLUtil$ {
    public static final URLUtil$ MODULE$ = new URLUtil$();
    private static Regex ExtRegexp;
    private static volatile boolean bitmap$0;

    private Regex ExtRegexp$lzycompute() {
        URLUtil$ uRLUtil$ = this;
        synchronized (uRLUtil$) {
            if (!bitmap$0) {
                ExtRegexp = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(.*)(\\.[^.]+)$"));
                bitmap$0 = true;
            }
        }
        return ExtRegexp;
    }

    private Regex ExtRegexp() {
        return !bitmap$0 ? this.ExtRegexp$lzycompute() : ExtRegexp;
    }

    public Future<File> download(String url, ExecutionContext ctx) {
        return package$Implicits$.MODULE$.RichTry(URL$.MODULE$.apply(url)).toFuture().flatMap((Function1 & Serializable)u -> MODULE$.download((URL)u, ctx).map((Function1 & Serializable)res -> res, ctx), ctx);
    }

    public Future<File> download(java.net.URL url, ExecutionContext ctx) {
        return this.download(URL$.MODULE$.apply(url), ctx);
    }

    public Future<File> download(URL url, ExecutionContext ctx) {
        return package$Implicits$.MODULE$.RichTry(this.getOutputFile(url)).toFuture().flatMap((Function1 & Serializable)output -> MODULE$.download(url, output.getPath(), ctx).map((Function1 & Serializable)x$1 -> {
            String string = x$1;
            File file = output;
            return file;
        }, ctx), ctx);
    }

    public Future<String> download(String url, String pathOut, ExecutionContext ctx) {
        return package$Implicits$.MODULE$.RichTry(URL$.MODULE$.apply(url)).toFuture().flatMap((Function1 & Serializable)u -> MODULE$.download((URL)u, new File(pathOut), ctx).map((Function1 & Serializable)f -> f.getPath(), ctx), ctx);
    }

    public Future<String> download(java.net.URL url, String pathOut, ExecutionContext ctx) {
        return this.download(URL$.MODULE$.apply(url), new File(pathOut), ctx).map((Function1 & Serializable)x$2 -> x$2.getPath(), ctx);
    }

    public Future<String> download(URL url, String pathOut, ExecutionContext ctx) {
        return this.download(url, new File(pathOut), ctx).map((Function1 & Serializable)f -> f.getPath(), ctx);
    }

    public Future<String> download(String url, File pathOut, ExecutionContext ctx) {
        return package$Implicits$.MODULE$.RichTry(URL$.MODULE$.apply(url)).toFuture().flatMap((Function1 & Serializable)u -> MODULE$.download((URL)u, pathOut, ctx).map((Function1 & Serializable)x$3 -> {
            File file = x$3;
            String string = pathOut.getPath();
            return string;
        }, ctx), ctx);
    }

    public Future<File> download(URL url, File pathOut, ExecutionContext ctx) {
        return URLUtil$.validateAndGetParentDir$1(pathOut, pathOut).flatMap((Function1 & Serializable)parentDir -> URLUtil$.openInputAndOutput$1(url, pathOut, pathOut, ctx).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)URLUtil$.$anonfun$download$18(check$ifrefutable$1)), ctx).flatMap((Function1 & Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            InputStream in = (InputStream)tuple2._1();
            OutputStream out = (OutputStream)tuple2._2();
            Future future = URLUtil$.doCopy$1(in, out, ctx).map((Function1 & Serializable)x$4 -> {
                BoxedUnit boxedUnit = x$4;
                out.close();
                in.close();
                File file = pathOut;
                return file;
            }, ctx);
            return future;
        }, ctx), ctx);
    }

    public <T> Try<T> withDownloadedFile(String url, Duration timeout, Function1<File, T> block, ExecutionContext ctx) {
        return URL$.MODULE$.apply(url).flatMap((Function1 & Serializable)u -> MODULE$.withDownloadedFile((URL)u, timeout, block, ctx).map((Function1 & Serializable)res -> res));
    }

    public <T> Try<T> withDownloadedFile(java.net.URL url, Duration timeout, Function1<File, T> block, ExecutionContext ctx) {
        return this.withDownloadedFile(URL$.MODULE$.apply(url), timeout, block, ctx);
    }

    public <T> Try<T> withDownloadedFile(URL url, Duration timeout, Function1<File, T> block, ExecutionContext ctx) {
        Future fut = this.download(url, ctx).map((Function1 & Serializable)res -> block.apply(res), ctx);
        return Try$.MODULE$.apply((Function0 & Serializable)() -> Await$.MODULE$.result((Awaitable)fut, timeout));
    }

    public Try<File> getOutputFile(URL url) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (File)url.path().map((Function1 & Serializable)pathStr -> {
            File file;
            String ext;
            Option option;
            String string = pathStr;
            String string2 = string != null && !(option = MODULE$.ExtRegexp().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0 ? (ext = (String)((LinearSeqOps)option.get()).apply(1)) : ".dat";
            String extension = string2;
            char c = StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(pathStr));
            switch (c) {
                case '/': {
                    file = File.createTempFile("urldownload", extension);
                    break;
                }
                default: {
                    file = new File(util$.MODULE$.joinPath((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{System.getProperty("java.io.tmpdir"), util$.MODULE$.basename((String)pathStr, util$.MODULE$.basename$default$2())})));
                    break;
                }
            }
            return file;
        }).getOrElse((Function0 & Serializable)() -> File.createTempFile("urldownload", ".dat")));
    }

    private static final Future validateAndGetParentDir$1(File path, File pathOut$3) {
        File dir;
        return path.isDirectory() ? Future$.MODULE$.failed((Throwable)new IOException(new StringBuilder(41).append("Output file \"").append(pathOut$3.toString()).append("\" exists and is a directory.").toString())) : (!(dir = grizzled.file.Implicits$.MODULE$.GrizzledFile(pathOut$3).dirname()).exists() && !dir.mkdirs() ? Future$.MODULE$.failed((Throwable)new IOException(new StringBuilder(55).append("Can't create target directory '").append(dir.toString()).append("' or one of its parents.").toString())) : Future$.MODULE$.successful((Object)dir));
    }

    private static final Future openInputAndOutput$1(URL url, File path, File pathOut$3, ExecutionContext ctx$5) {
        return package$Implicits$.MODULE$.RichTry(url.openStream()).toFuture().flatMap((Function1 & Serializable)urlIn -> package$Implicits$.MODULE$.RichTry(Try$.MODULE$.apply((Function0 & Serializable)() -> new BufferedInputStream((InputStream)urlIn))).toFuture().flatMap((Function1 & Serializable)in -> package$Implicits$.MODULE$.RichTry(Try$.MODULE$.apply((Function0 & Serializable)() -> new BufferedOutputStream(new FileOutputStream(pathOut$3)))).toFuture().map((Function1 & Serializable)out -> new Tuple2(in, out), ctx$5), ctx$5), ctx$5);
    }

    private static final Future doCopy$1(InputStream in, OutputStream out, ExecutionContext ctx$5) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> Implicits$.MODULE$.RichInputStream(in).copyTo(out), ctx$5);
    }

    public static final /* synthetic */ boolean $anonfun$download$18(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private URLUtil$() {
    }
}

