/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.maven2.Configuration;
import org.codehaus.cargo.maven2.Container;
import org.codehaus.cargo.maven2.Deployable;
import org.codehaus.cargo.maven2.Deployer;
import org.codehaus.cargo.maven2.monitor.MavenMonitor;
import org.codehaus.cargo.maven2.util.CargoProject;
import org.codehaus.cargo.util.monitor.FileMonitor;
import org.codehaus.cargo.util.monitor.Monitor;

public abstract class AbstractCargoMojo
extends AbstractMojo {
    protected MavenProject project;
    private Configuration configuration;
    private Container container;
    private Deployer deployer;
    private CargoProject cargoProject;

    public void setDeployer(Deployer deployer) {
        this.deployer = deployer;
    }

    protected Deployer getDeployerElement() {
        return this.deployer;
    }

    protected Configuration getConfigurationElement() {
        return this.configuration;
    }

    protected void setConfigurationElement(Configuration configurationElement) {
        this.configuration = configurationElement;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    protected Container getContainerElement() {
        return this.container;
    }

    protected void setContainerElement(Container containerElement) {
        this.container = containerElement;
    }

    public void execute() throws MojoExecutionException {
        if (this.cargoProject == null) {
            this.cargoProject = new CargoProject(this.project, this.getLog());
        }
    }

    protected void setCargoProject(CargoProject cargoProject) {
        this.cargoProject = cargoProject;
    }

    protected CargoProject getCargoProject() {
        return this.cargoProject;
    }

    protected org.codehaus.cargo.container.configuration.Configuration createConfiguration() throws MojoExecutionException {
        org.codehaus.cargo.container.configuration.Configuration configuration;
        if (this.getConfigurationElement() == null) {
            DefaultConfigurationFactory factory = new DefaultConfigurationFactory();
            configuration = factory.createConfiguration(this.computeContainerId(), ConfigurationType.STANDALONE, new File(this.getCargoProject().getBuildDirectory(), this.computeContainerId()));
        } else {
            configuration = this.getConfigurationElement().createConfiguration(this.computeContainerId(), this.getCargoProject());
        }
        return configuration;
    }

    private String computeContainerId() {
        String id = this.getContainerElement() == null ? "jetty4xEmbedded" : this.getContainerElement().getContainerId();
        return id;
    }

    protected org.codehaus.cargo.container.Container createContainer() throws MojoExecutionException {
        org.codehaus.cargo.container.Container container;
        if (this.getContainerElement() == null) {
            if (this.getCargoProject().getPackaging() != null && !this.getCargoProject().getPackaging().equalsIgnoreCase("war")) {
                throw new MojoExecutionException("For all packaging other than war you need to configure the container you wishes to use.");
            }
            this.getLog().info((CharSequence)("No container defined, using a default [" + this.computeContainerId() + "] container"));
            DefaultContainerFactory factory = new DefaultContainerFactory();
            container = factory.createContainer(this.computeContainerId(), this.createConfiguration());
        } else {
            container = this.getContainerElement().createContainer(this.createConfiguration(), this.createMonitor());
        }
        return container;
    }

    protected org.codehaus.cargo.container.deployable.Deployable createAutoDeployDeployable(org.codehaus.cargo.container.Container container) throws MojoExecutionException {
        Deployable deployableElement = new Deployable();
        return deployableElement.createDeployable(container.getId(), this.getCargoProject());
    }

    protected boolean containsAutoDeployable(Deployable[] deployableElements) {
        boolean found = false;
        for (int i = 0; i < deployableElements.length; ++i) {
            Deployable deployableElement = deployableElements[i];
            if (!deployableElement.getGroupId().equals(this.getCargoProject().getGroupId()) || !deployableElement.getArtifactId().equals(this.getCargoProject().getArtifactId())) continue;
            found = true;
            break;
        }
        return found;
    }

    protected Monitor createMonitor() {
        MavenMonitor monitor;
        if (this.getContainerElement() != null && this.getContainerElement().getLog() != null) {
            this.getContainerElement().getLog().getParentFile().mkdirs();
            monitor = new FileMonitor(this.getContainerElement().getLog(), false);
        } else {
            monitor = new MavenMonitor(this.getLog());
        }
        return monitor;
    }
}

