/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.net.URL;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.internal.util.HttpUtils;
import org.codehaus.cargo.container.spi.util.ContainerUtils;
import org.codehaus.cargo.maven2.AbstractCargoMojo;

public class ContainerStartMojo
extends AbstractCargoMojo {
    private static final int SLEEP = 100;
    private boolean wait;

    public void execute() throws MojoExecutionException {
        super.execute();
        Container container = this.createContainer();
        if (container.getType() != ContainerType.LOCAL) {
            throw new MojoExecutionException("Only local containers can be started");
        }
        LocalContainer localContainer = (LocalContainer)container;
        this.addAutoDeployDeployable(localContainer);
        localContainer.start();
        if (this.wait) {
            this.getLog().info((CharSequence)"Press Ctrl-C to stop the container...");
            this.waitForever(ContainerUtils.getCPCURL((Configuration)localContainer.getConfiguration()));
        }
    }

    protected void addAutoDeployDeployable(LocalContainer container) throws MojoExecutionException {
        if (this.getDeployerElement() == null && this.getCargoProject().getPackaging() != null && this.getCargoProject().isJ2EEPackaging() && (this.getConfigurationElement() == null || this.getConfigurationElement().getDeployables() == null || !this.containsAutoDeployable(this.getConfigurationElement().getDeployables()))) {
            LocalConfiguration configuration = container.getConfiguration();
            configuration.addDeployable(this.createAutoDeployDeployable((Container)container));
        }
    }

    public void waitForever(URL urlToCheckFor) {
        HttpUtils httpUtils = new HttpUtils();
        try {
            boolean isDeployed = true;
            do {
                isDeployed = httpUtils.ping(urlToCheckFor);
                Thread.sleep(100L);
            } while (isDeployed);
        }
        catch (InterruptedException exception) {
            this.getLog().warn((Throwable)exception);
        }
    }
}

