/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.tools.ant.BuildException;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.maven2.util.CargoProject;

public class Deployable {
    private String groupId;
    private String artifactId;
    private URL pingURL;
    private String type;
    private Class implementation;
    private Map properties;
    private String location;
    static /* synthetic */ Class class$java$lang$String;

    public Map getProperties() {
        return this.properties;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public URL getPingURL() {
        return this.pingURL;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setImplementation(Class implementation) {
        this.implementation = implementation;
    }

    public Class getImplementation() {
        return this.implementation;
    }

    org.codehaus.cargo.container.deployable.Deployable createDeployable(String containerId, CargoProject project) throws MojoExecutionException {
        if (this.getGroupId() == null) {
            this.setGroupId(project.getGroupId());
        }
        if (this.getType() == null) {
            this.setType(project.getPackaging());
        }
        if (this.getArtifactId() == null) {
            this.setArtifactId(project.getArtifactId());
        }
        if (this.getLocation() == null) {
            this.setLocation(this.computeLocation(project));
        }
        if (!new File(this.getLocation()).exists()) {
            throw new MojoExecutionException("Deployable [" + this.getLocation() + "] does not exist and thus cannot be deployed.");
        }
        DefaultDeployableFactory factory = new DefaultDeployableFactory();
        if (this.getImplementation() != null) {
            factory.registerDeployable(containerId, DeployableType.toType((String)this.getType()), this.getImplementation());
        }
        org.codehaus.cargo.container.deployable.Deployable deployable = factory.createDeployable(containerId, this.getLocation(), DeployableType.toType((String)this.getType()));
        if (this.getProperties() != null) {
            Iterator props = this.getProperties().keySet().iterator();
            while (props.hasNext()) {
                String propertyName = (String)props.next();
                project.getLog().debug((CharSequence)("Setting deployable property [" + propertyName + "]:[" + this.getProperties().get(propertyName) + "] for [" + this.getLocation() + "]"));
                this.callMethodForProperty(deployable, propertyName, (String)this.getProperties().get(propertyName));
            }
        }
        return deployable;
    }

    protected String computeLocation(CargoProject project) throws MojoExecutionException {
        String location = project.getGroupId().equals(this.getGroupId()) && project.getArtifactId().equals(this.getArtifactId()) ? new File(project.getBuildDirectory(), project.getFinalName() + "." + project.getPackaging()).getPath() : this.findArtifactLocation(project.getArtifacts(), project.getLog());
        return location;
    }

    protected String findArtifactLocation(Set artifacts, Log log) throws MojoExecutionException {
        Artifact resolvedArtifact = null;
        log.debug((CharSequence)("Searching for an artifact that matches [" + this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getType() + "]..."));
        Iterator it = artifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            log.debug((CharSequence)("Checking artifact [" + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + "]..."));
            if (!artifact.getGroupId().equals(this.getGroupId()) || !artifact.getArtifactId().equals(this.getArtifactId())) continue;
            resolvedArtifact = artifact;
            break;
        }
        if (resolvedArtifact == null) {
            throw new MojoExecutionException("Artifact [" + this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getType() + "] is not a dependency of the project.");
        }
        return resolvedArtifact.getFile().getPath();
    }

    private void callMethodForProperty(org.codehaus.cargo.container.deployable.Deployable deployable, String name, String value) {
        try {
            Method method = deployable.getClass().getMethod(this.getSetterMethodName(name), class$java$lang$String == null ? (class$java$lang$String = Deployable.class$("java.lang.String")) : class$java$lang$String);
            method.invoke((Object)deployable, value);
        }
        catch (Exception e) {
            throw new BuildException("Invalid property [" + name + "] for deployable type [" + deployable.getType() + "]", (Throwable)e);
        }
    }

    protected String getSetterMethodName(String propertyName) {
        return "set" + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

