/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Hashtable;
import java.util.Properties;

public class Proxy {
    private String host;
    private int port = 80;
    private String user;
    private String password;
    private String excludeHosts = "";

    public final void setHost(String host) {
        this.host = host;
    }

    public final String getHost() {
        return this.host;
    }

    public final void setPort(int port) {
        this.port = port;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setUser(String user) {
        this.user = user;
    }

    public final String getUser() {
        return this.user;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setExcludeHosts(String proxyExcludeHosts) {
        this.excludeHosts = proxyExcludeHosts;
    }

    public final String getExcludeHosts() {
        return this.excludeHosts;
    }

    public void configure() {
        if (this.getHost() != null && this.getHost().trim().length() > 0) {
            Properties sysprops = System.getProperties();
            String portString = Integer.toString(this.getPort());
            ((Hashtable)sysprops).put("http.proxyHost", this.getHost());
            ((Hashtable)sysprops).put("http.proxyPort", portString);
            ((Hashtable)sysprops).put("https.proxyHost", this.getHost());
            ((Hashtable)sysprops).put("https.proxyPort", portString);
            ((Hashtable)sysprops).put("ftp.proxyHost", this.getHost());
            ((Hashtable)sysprops).put("ftp.proxyPort", portString);
            if (this.getExcludeHosts() != null) {
                ((Hashtable)sysprops).put("http.nonProxyHosts", this.getExcludeHosts());
                ((Hashtable)sysprops).put("https.nonProxyHosts", this.getExcludeHosts());
                ((Hashtable)sysprops).put("ftp.nonProxyHosts", this.getExcludeHosts());
            }
            if (this.getUser() != null) {
                ((Hashtable)sysprops).put("http.proxyUser", this.getUser());
                ((Hashtable)sysprops).put("http.proxyPassword", this.getPassword());
                Authenticator.setDefault(new ProxyAuthenticator(this.getUser(), this.getPassword()));
            }
        }
    }

    public void clear() {
        Properties sysprops = System.getProperties();
        ((Hashtable)sysprops).remove("http.proxyHost");
        ((Hashtable)sysprops).remove("http.proxyPort");
        ((Hashtable)sysprops).remove("http.proxyUser");
        ((Hashtable)sysprops).remove("http.proxyPassword");
        ((Hashtable)sysprops).remove("https.proxyHost");
        ((Hashtable)sysprops).remove("https.proxyPort");
        ((Hashtable)sysprops).remove("ftp.proxyHost");
        ((Hashtable)sysprops).remove("ftp.proxyPort");
        Authenticator.setDefault(new ProxyAuthenticator("", ""));
    }

    private static final class ProxyAuthenticator
    extends Authenticator {
        private PasswordAuthentication authentication;

        private ProxyAuthenticator(String user, String pass) {
            this.authentication = new PasswordAuthentication(user, pass.toCharArray());
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.authentication;
        }
    }
}

