/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import java.util.Enumeration;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import org.castor.core.util.Assert;
import org.exolab.castor.xml.NamespacesStack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StaxEventHandler
extends DefaultHandler {
    private final XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private final XMLEventWriter xmlEventWriter;
    private NamespacesStack namespacesStack = new NamespacesStack();
    private boolean createNamespaceScope = true;

    public StaxEventHandler(XMLEventWriter xmlEventWriter) {
        Assert.paramNotNull((Object)xmlEventWriter, (String)"xmlEventWriter");
        this.xmlEventWriter = xmlEventWriter;
    }

    public void startDocument() throws SAXException {
        try {
            this.xmlEventWriter.add(this.eventFactory.createStartDocument());
        }
        catch (XMLStreamException e) {
            this.convertToSAXException("Error occurred when writing document start.", e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.xmlEventWriter.add(this.eventFactory.createEndDocument());
        }
        catch (XMLStreamException e) {
            this.convertToSAXException("Error occurred when writing document end.", e);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.createNamespaceScope) {
            this.namespacesStack.addNewNamespaceScope();
            this.createNamespaceScope = false;
        }
        this.namespacesStack.addNamespace(prefix, uri);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            this.xmlEventWriter.add(this.eventFactory.createStartElement(new QName(qName), new AttributeIterator(attributes), new NamespaceIterator(this.namespacesStack)));
        }
        catch (XMLStreamException e) {
            this.convertToSAXException("Error occurred when writing element start.", e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.xmlEventWriter.add(this.eventFactory.createEndElement(new QName(qName), null));
        }
        catch (XMLStreamException e) {
            this.convertToSAXException("Error occurred when writing element end.", e);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.xmlEventWriter.add(this.eventFactory.createCharacters(new String(ch, start, length)));
        }
        catch (XMLStreamException e) {
            this.convertToSAXException("Error occurred when writing white spaces.", e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.xmlEventWriter.add(this.eventFactory.createCharacters(new String(ch, start, length)));
        }
        catch (XMLStreamException e) {
            this.convertToSAXException("Error occurred when writing characters.", e);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.xmlEventWriter.add(this.eventFactory.createProcessingInstruction(target, data));
        }
        catch (XMLStreamException e) {
            this.convertToSAXException("Error occurred when writing processing instruction.", e);
        }
    }

    private void convertToSAXException(String msg, XMLStreamException e) throws SAXException {
        throw new SAXException(msg, e);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NamespaceIterator
    implements Iterator<Namespace> {
        private final NamespacesStack namespaces;
        private final Enumeration namespaceEnumerator;
        private boolean hasDefaultNamespace;
        private boolean defaultNamespaceWritten;

        private NamespaceIterator(NamespacesStack namespaces) {
            this.namespaces = namespaces;
            this.namespaceEnumerator = namespaces.getLocalNamespacePrefixes();
            String defaultNamespace = namespaces.getDefaultNamespaceURI();
            if (defaultNamespace != null && defaultNamespace.length() > 0) {
                this.hasDefaultNamespace = true;
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasDefaultNamespace && !this.defaultNamespaceWritten || this.namespaceEnumerator.hasMoreElements();
        }

        @Override
        public Namespace next() {
            Namespace namespace;
            if (this.hasDefaultNamespace && !this.defaultNamespaceWritten) {
                namespace = StaxEventHandler.this.eventFactory.createNamespace(this.namespaces.getDefaultNamespaceURI());
                this.defaultNamespaceWritten = true;
            } else {
                String prefix = (String)this.namespaceEnumerator.nextElement();
                namespace = StaxEventHandler.this.eventFactory.createNamespace(prefix, this.namespaces.getNamespaceURI(prefix));
            }
            return namespace;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Method 'remove' is not supported.");
        }
    }

    private class AttributeIterator
    implements Iterator {
        private final Attributes attributes;
        private int index;

        private AttributeIterator(Attributes attributes) {
            this.attributes = attributes;
        }

        public boolean hasNext() {
            return this.index < this.attributes.getLength();
        }

        public Object next() {
            Attribute attribute = StaxEventHandler.this.eventFactory.createAttribute(this.attributes.getQName(this.index), this.attributes.getValue(this.index));
            ++this.index;
            return attribute;
        }

        public void remove() {
            throw new UnsupportedOperationException("Method 'remove' is not supported.");
        }
    }
}

