/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmaven.adapter.impl;

import com.google.common.base.Preconditions;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.ui.Console;
import java.util.EventObject;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.gmaven.adapter.ConsoleWindow;
import org.codehaus.gmaven.adapter.ResourceLoader;
import org.codehaus.gmaven.adapter.impl.GroovyRuntimeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleWindowImpl
implements ConsoleWindow {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final GroovyRuntimeImpl runtime;
    private final Object lock = new Object();

    ConsoleWindowImpl(GroovyRuntimeImpl runtime) {
        this.runtime = (GroovyRuntimeImpl)Preconditions.checkNotNull((Object)runtime);
    }

    public ConsoleWindow.WindowHandle open(ClassLoader classLoader, ResourceLoader resourceLoader, Map<String, Object> context, @Nullable Map<String, Object> options) throws Exception {
        Preconditions.checkNotNull((Object)classLoader);
        Preconditions.checkNotNull((Object)resourceLoader);
        Preconditions.checkNotNull(context);
        this.log.trace("Opening; class-loader: {}, resource-loader: {}, context: {}", new Object[]{classLoader, resourceLoader, context});
        final GroovyClassLoader gcl = this.runtime.createGroovyClassLoader(classLoader, resourceLoader);
        Binding binding = this.runtime.createBinding(context);
        final Console console = new Console((ClassLoader)gcl, binding){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void exit(EventObject event) {
                try {
                    super.exit(event);
                }
                finally {
                    Object object = ConsoleWindowImpl.this.lock;
                    synchronized (object) {
                        ConsoleWindowImpl.this.lock.notifyAll();
                    }
                }
            }
        };
        if (options != null) {
            this.configureOptions(console, options);
        }
        this.log.trace("Opening");
        console.run();
        return new ConsoleWindow.WindowHandle(){

            public void close() {
                ConsoleWindowImpl.this.log.trace("Closing");
                console.exit();
                this.cleanup();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void await() throws InterruptedException {
                ConsoleWindowImpl.this.log.trace("Waiting");
                Object object = ConsoleWindowImpl.this.lock;
                synchronized (object) {
                    ConsoleWindowImpl.this.lock.wait();
                }
                this.cleanup();
            }

            private void cleanup() {
                gcl.clearCache();
            }
        };
    }

    private void configureOptions(Console console, Map<String, Object> options) {
    }
}

