/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.gmavenplus.model.IncludeClasspath;
import org.codehaus.gmavenplus.model.internal.Version;
import org.codehaus.gmavenplus.mojo.AbstractGroovySourcesMojo;
import org.codehaus.gmavenplus.util.ReflectionUtils;

public abstract class AbstractCompileMojo
extends AbstractGroovySourcesMojo {
    protected static final Version GROOVY_5_0_0_ALPHA1 = new Version(5, 0, 0, "alpha-1");
    protected static final Version GROOVY_4_0_11 = new Version(4, 0, 11);
    protected static final Version GROOVY_4_0_6 = new Version(4, 0, 6);
    protected static final Version GROOVY_4_0_2 = new Version(4, 0, 2);
    protected static final Version GROOVY_4_0_0_BETA1 = new Version(4, 0, 0, "beta-1");
    protected static final Version GROOVY_4_0_0_ALPHA3 = new Version(4, 0, 0, "alpha-3");
    protected static final Version GROOVY_4_0_0_ALPHA1 = new Version(4, 0, 0, "alpha-1");
    protected static final Version GROOVY_3_0_8 = new Version(3, 0, 8);
    protected static final Version GROOVY_3_0_6 = new Version(3, 0, 6);
    protected static final Version GROOVY_3_0_5 = new Version(3, 0, 5);
    protected static final Version GROOVY_3_0_3 = new Version(3, 0, 3);
    protected static final Version GROOVY_3_0_0_BETA2 = new Version(3, 0, 0, "beta-2");
    protected static final Version GROOVY_3_0_0_BETA1 = new Version(3, 0, 0, "beta-1");
    protected static final Version GROOVY_3_0_0_ALPHA4 = new Version(3, 0, 0, "alpha-4");
    protected static final Version GROOVY_3_0_0_ALPHA2 = new Version(3, 0, 0, "alpha-2");
    protected static final Version GROOVY_3_0_0_ALPHA1 = new Version(3, 0, 0, "alpha-1");
    protected static final Version GROOVY_2_6_0_ALPHA4 = new Version(2, 6, 0, "alpha-4");
    protected static final Version GROOVY_2_6_0_ALPHA1 = new Version(2, 6, 0, "alpha-1");
    protected static final Version GROOVY_2_5_7 = new Version(2, 5, 7);
    protected static final Version GROOVY_2_5_3 = new Version(2, 5, 3);
    protected static final Version GROOVY_2_5_0_ALPHA1 = new Version(2, 5, 0, "alpha-1");
    protected static final Version GROOVY_2_3_3 = new Version(2, 3, 3);
    protected static final Version GROOVY_2_1_3 = new Version(2, 1, 3);
    protected static final Version GROOVY_2_1_0_BETA1 = new Version(2, 1, 0, "beta-1");
    protected static final Version GROOVY_2_0_0_BETA3 = new Version(2, 0, 0, "beta-3");
    protected static final Version GROOVY_1_6_0 = new Version(1, 6, 0);
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String sourceEncoding;
    @Parameter(property="maven.compiler.target", defaultValue="1.8")
    protected String targetBytecode;
    @Parameter(property="skipBytecodeCheck", defaultValue="false")
    protected boolean skipBytecodeCheck;
    @Parameter(defaultValue="false")
    protected boolean debug;
    @Parameter(defaultValue="false")
    protected boolean verbose;
    @Parameter(defaultValue="1")
    protected int warningLevel;
    @Parameter(defaultValue="0")
    protected int tolerance;
    @Parameter(defaultValue="false")
    protected boolean invokeDynamic;
    @Parameter
    protected Boolean parallelParsing = null;
    @Parameter
    protected File configScript;
    @Parameter(defaultValue="false")
    protected boolean parameters;
    @Parameter(defaultValue="PROJECT_ONLY")
    protected IncludeClasspath includeClasspath;
    @Parameter(defaultValue="false")
    protected boolean previewFeatures;

    protected synchronized void doCompile(Set<File> sources, List classpath, File compileOutputDirectory) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, MalformedURLException {
        if (sources == null || sources.isEmpty()) {
            this.getLog().info((CharSequence)"No sources specified for compilation. Skipping.");
            return;
        }
        this.setupClassWrangler(classpath, this.includeClasspath);
        this.logPluginClasspath();
        this.classWrangler.logGroovyVersion(this.mojoExecution.getMojoDescriptor().getGoal());
        if (!this.groovyVersionSupportsAction()) {
            this.getLog().error((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support compilation. The minimum version of Groovy required is " + this.minGroovyVersion + ". Skipping compiling."));
            return;
        }
        if (!this.skipBytecodeCheck) {
            this.verifyGroovyVersionSupportsTargetBytecode();
        }
        Class<?> compilerConfigurationClass = this.classWrangler.getClass("org.codehaus.groovy.control.CompilerConfiguration");
        Class<?> compilationUnitClass = this.classWrangler.getClass("org.codehaus.groovy.control.CompilationUnit");
        Class<?> groovyClassLoaderClass = this.classWrangler.getClass("groovy.lang.GroovyClassLoader");
        Object compilerConfiguration = this.setupCompilerConfiguration(compileOutputDirectory, compilerConfigurationClass);
        Object groovyClassLoader = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyClassLoaderClass, ClassLoader.class, compilerConfigurationClass), this.classWrangler.getClassLoader(), compilerConfiguration);
        Object transformLoader = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyClassLoaderClass, ClassLoader.class), this.classWrangler.getClassLoader());
        Object compilationUnit = this.setupCompilationUnit(sources, compilerConfigurationClass, compilationUnitClass, groovyClassLoaderClass, compilerConfiguration, groovyClassLoader, transformLoader);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilationUnitClass, "compile", new Class[0]), compilationUnit, new Object[0]);
        List classes = (List)ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilationUnitClass, "getClasses", new Class[0]), compilationUnit, new Object[0]);
        this.getLog().info((CharSequence)("Compiled " + classes.size() + " file" + (classes.size() != 1 ? "s" : "") + "."));
    }

    protected Object setupCompilationUnit(Set<File> sources, Class<?> compilerConfigurationClass, Class<?> compilationUnitClass, Class<?> groovyClassLoaderClass, Object compilerConfiguration, Object groovyClassLoader, Object transformLoader) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        Object compilationUnit = this.groovyAtLeast(GROOVY_1_6_0) ? ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilationUnitClass, compilerConfigurationClass, CodeSource.class, groovyClassLoaderClass, groovyClassLoaderClass), compilerConfiguration, null, groovyClassLoader, transformLoader) : ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilationUnitClass, compilerConfigurationClass, CodeSource.class, groovyClassLoaderClass), compilerConfiguration, null, groovyClassLoader);
        this.getLog().debug((CharSequence)"Adding Groovy to compile:");
        Method addSourceMethod = ReflectionUtils.findMethod(compilationUnitClass, "addSource", File.class);
        for (File source : sources) {
            this.getLog().debug((CharSequence)("    " + source));
            ReflectionUtils.invokeMethod(addSourceMethod, compilationUnit, source);
        }
        return compilationUnit;
    }

    protected Object setupCompilerConfiguration(File compileOutputDirectory, Class<?> compilerConfigurationClass) throws InvocationTargetException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        Map optimizationOptions;
        Object compilerConfiguration = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilerConfigurationClass, new Class[0]), new Object[0]);
        if (this.configScript != null) {
            if (!this.configScript.exists()) {
                this.getLog().warn((CharSequence)("Configuration script file (" + this.configScript.getAbsolutePath() + ") doesn't exist. Ignoring configScript parameter."));
            } else if (this.groovyOlderThan(GROOVY_2_1_0_BETA1)) {
                this.getLog().warn((CharSequence)("Requested to use configScript, but your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support it (must be " + GROOVY_2_1_0_BETA1 + " or newer). Ignoring configScript parameter."));
            } else {
                Class<?> bindingClass = this.classWrangler.getClass("groovy.lang.Binding");
                Class<?> importCustomizerClass = this.classWrangler.getClass("org.codehaus.groovy.control.customizers.ImportCustomizer");
                Class<?> groovyShellClass = this.classWrangler.getClass("groovy.lang.GroovyShell");
                Object binding = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(bindingClass, new Class[0]), new Object[0]);
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(bindingClass, "setVariable", String.class, Object.class), binding, "configuration", compilerConfiguration);
                Object shellCompilerConfiguration = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(compilerConfigurationClass, new Class[0]), new Object[0]);
                Object importCustomizer = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(importCustomizerClass, new Class[0]), new Object[0]);
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(importCustomizerClass, "addStaticStar", String.class), importCustomizer, "org.codehaus.groovy.control.customizers.builder.CompilerCustomizationBuilder");
                List compilationCustomizers = (List)ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "getCompilationCustomizers", new Class[0]), shellCompilerConfiguration, new Object[0]);
                compilationCustomizers.add(importCustomizer);
                Object shell = ReflectionUtils.invokeConstructor(ReflectionUtils.findConstructor(groovyShellClass, ClassLoader.class, bindingClass, compilerConfigurationClass), this.classWrangler.getClassLoader(), binding, shellCompilerConfiguration);
                this.getLog().debug((CharSequence)("Using configuration script " + this.configScript + " for compilation."));
                ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(groovyShellClass, "evaluate", File.class), shell, this.configScript);
            }
        }
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setDebug", Boolean.TYPE), compilerConfiguration, this.debug);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setVerbose", Boolean.TYPE), compilerConfiguration, this.verbose);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setWarningLevel", Integer.TYPE), compilerConfiguration, this.warningLevel);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTolerance", Integer.TYPE), compilerConfiguration, this.tolerance);
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTargetBytecode", String.class), compilerConfiguration, AbstractCompileMojo.translateJavacTargetToTargetBytecode(this.targetBytecode));
        if (this.previewFeatures) {
            if (this.isJavaSupportPreviewFeatures()) {
                if (this.groovyOlderThan(GROOVY_2_5_7) || this.groovyAtLeast(GROOVY_2_6_0_ALPHA1) && this.groovyOlderThan(GROOVY_3_0_0_BETA1)) {
                    this.getLog().warn((CharSequence)("Requested to use preview features, but your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support it (must be " + GROOVY_2_5_7 + "/" + GROOVY_3_0_0_BETA1 + " or newer. No 2.6 version is supported. Ignoring previewFeatures parameter."));
                } else {
                    ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setPreviewFeatures", Boolean.TYPE), compilerConfiguration, this.previewFeatures);
                }
            } else {
                this.getLog().warn((CharSequence)("Requested to use to use preview features, but your Java version (" + this.getJavaVersionString() + ") doesn't support it. Ignoring previewFeatures parameter."));
            }
        }
        if (this.sourceEncoding != null) {
            ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setSourceEncoding", String.class), compilerConfiguration, this.sourceEncoding);
        }
        ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setTargetDirectory", String.class), compilerConfiguration, compileOutputDirectory.getAbsolutePath());
        if (this.invokeDynamic || this.groovyAtLeast(GROOVY_4_0_0_ALPHA1)) {
            if (this.groovyAtLeast(GROOVY_2_0_0_BETA3)) {
                if (this.classWrangler.isGroovyIndy()) {
                    if (this.isJavaSupportIndy()) {
                        optimizationOptions = (Map)ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "getOptimizationOptions", new Class[0]), compilerConfiguration, new Object[0]);
                        optimizationOptions.put("indy", true);
                        optimizationOptions.put("int", false);
                        this.getLog().info((CharSequence)"invokedynamic enabled.");
                    } else {
                        this.getLog().warn((CharSequence)("Requested to use to use invokedynamic, but your Java version (" + this.getJavaVersionString() + ") doesn't support it. Ignoring invokeDynamic parameter."));
                    }
                } else {
                    this.getLog().warn((CharSequence)"Requested to use invokedynamic, but your Groovy version doesn't support it (must use have indy classifier). Ignoring invokeDynamic parameter.");
                }
            } else {
                this.getLog().warn((CharSequence)("Requested to use invokeDynamic, but your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support it (must be " + GROOVY_2_0_0_BETA3 + " or newer). Ignoring invokeDynamic parameter."));
            }
        }
        if (this.parameters) {
            if (this.groovyAtLeast(GROOVY_2_5_0_ALPHA1)) {
                if (this.isJavaSupportParameters()) {
                    ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "setParameters", Boolean.TYPE), compilerConfiguration, this.parameters);
                } else {
                    this.getLog().warn((CharSequence)("Requested to use to use parameters, but your Java version (" + this.getJavaVersionString() + ") doesn't support it. Ignoring parameters parameter."));
                }
            } else {
                this.getLog().warn((CharSequence)("Requested to use parameters, but your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support it (must be " + GROOVY_2_5_0_ALPHA1 + " or newer). Ignoring parameters parameter."));
            }
        }
        if (this.groovyAtLeast(GROOVY_3_0_5)) {
            if (this.parallelParsing == null && this.groovyAtLeast(GROOVY_4_0_0_ALPHA1) || this.parallelParsing != null && this.parallelParsing.booleanValue()) {
                optimizationOptions = (Map)ReflectionUtils.invokeMethod(ReflectionUtils.findMethod(compilerConfigurationClass, "getOptimizationOptions", new Class[0]), compilerConfiguration, new Object[0]);
                optimizationOptions.put("parallelParse", true);
                this.getLog().info((CharSequence)"Parallel parsing enabled.");
            } else {
                this.getLog().info((CharSequence)"Parallel parsing disabled.");
            }
        }
        return compilerConfiguration;
    }

    protected void verifyGroovyVersionSupportsTargetBytecode() {
        if (("1.5".equals(this.targetBytecode) || "5".equals(this.targetBytecode) || "1.6".equals(this.targetBytecode) || "6".equals(this.targetBytecode) || "1.7".equals(this.targetBytecode) || "7".equals(this.targetBytecode) || "1.8".equals(this.targetBytecode) || "8".equals(this.targetBytecode) || "1.9".equals(this.targetBytecode) || "9".equals(this.targetBytecode) || "10".equals(this.targetBytecode)) && this.groovyNewerThan(GROOVY_5_0_0_ALPHA1)) {
            throw new IllegalArgumentException("Target bytecode " + this.targetBytecode + " isn't accepted by Groovy " + GROOVY_5_0_0_ALPHA1 + " or newer.");
        }
        if ("21".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_4_0_11)) {
                throw new IllegalArgumentException("Target bytecode " + this.targetBytecode + " requires Groovy " + GROOVY_4_0_11 + " or newer.");
            }
        } else if ("20".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_4_0_6)) {
                throw new IllegalArgumentException("Target bytecode " + this.targetBytecode + " requires Groovy " + GROOVY_4_0_6 + " or newer.");
            }
        } else if ("19".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_4_0_2)) {
                throw new IllegalArgumentException("Target bytecode " + this.targetBytecode + " requires Groovy " + GROOVY_4_0_2 + " or newer.");
            }
        } else if ("18".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_4_0_0_BETA1)) {
                throw new IllegalArgumentException("Target bytecode " + this.targetBytecode + " requires Groovy " + GROOVY_4_0_0_BETA1 + " or newer.");
            }
        } else if ("17".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_3_0_8) || this.groovyAtLeast(GROOVY_4_0_0_ALPHA1) && this.groovyOlderThan(GROOVY_4_0_0_ALPHA3)) {
                throw new IllegalArgumentException("Target bytecode " + this.targetBytecode + " requires Groovy " + GROOVY_3_0_8 + "/" + GROOVY_4_0_0_ALPHA3 + " or newer.");
            }
        } else if ("16".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_3_0_6)) {
                throw new IllegalArgumentException("Target bytecode " + this.targetBytecode + " requires Groovy " + GROOVY_3_0_6 + " or newer.");
            }
        } else if ("15".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_3_0_3)) {
                throw new IllegalArgumentException("Target bytecode " + this.targetBytecode + " requires Groovy " + GROOVY_3_0_3 + " or newer.");
            }
        } else if ("14".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_3_0_0_BETA2)) {
                throw new IllegalArgumentException("Target bytecode " + this.targetBytecode + " requires Groovy " + GROOVY_3_0_0_BETA2 + " or newer.");
            }
        } else if ("13".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_2_5_7) || this.groovyAtLeast(GROOVY_2_6_0_ALPHA1) && this.groovyOlderThan(GROOVY_3_0_0_BETA1)) {
                throw new IllegalArgumentException("Target bytecode " + this.targetBytecode + " requires Groovy " + GROOVY_2_5_7 + "/" + GROOVY_3_0_0_BETA1 + " or newer. No 2.6 version is supported.");
            }
        } else if ("12".equals(this.targetBytecode) || "11".equals(this.targetBytecode) || "10".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_2_5_3) || this.groovyAtLeast(GROOVY_2_6_0_ALPHA1) && this.groovyOlderThan(GROOVY_3_0_0_ALPHA4)) {
                throw new IllegalArgumentException("Target bytecode " + this.targetBytecode + " requires Groovy " + GROOVY_2_5_3 + "/" + GROOVY_3_0_0_ALPHA4 + " or newer. No 2.6 version is supported.");
            }
        } else if ("9".equals(this.targetBytecode) || "1.9".equals(this.targetBytecode)) {
            if (!this.isGroovyIndy() && (this.groovyOlderThan(GROOVY_2_5_3) || this.groovyAtLeast(GROOVY_2_6_0_ALPHA1) && this.groovyOlderThan(GROOVY_2_6_0_ALPHA4) || this.groovyAtLeast(GROOVY_3_0_0_ALPHA1) && this.groovyOlderThan(GROOVY_3_0_0_ALPHA2))) {
                throw new IllegalArgumentException("Target bytecode " + this.targetBytecode + " requires Groovy " + GROOVY_2_5_3 + "/" + GROOVY_2_6_0_ALPHA4 + "/" + GROOVY_3_0_0_ALPHA2 + " or newer.");
            }
            if (this.isGroovyIndy() && (this.groovyOlderThan(GROOVY_2_5_3) || this.groovyAtLeast(GROOVY_2_6_0_ALPHA1) && this.groovyOlderThan(GROOVY_3_0_0_ALPHA4))) {
                throw new IllegalArgumentException("Target bytecode " + this.targetBytecode + " requires Groovy " + GROOVY_2_5_3 + "/" + GROOVY_3_0_0_ALPHA4 + " or newer. No 2.6 version is supported.");
            }
        } else if ("8".equals(this.targetBytecode) || "1.8".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_2_3_3)) {
                throw new IllegalArgumentException("Target bytecode " + this.targetBytecode + " requires Groovy " + GROOVY_2_3_3 + " or newer.");
            }
        } else if ("7".equals(this.targetBytecode) || "1.7".equals(this.targetBytecode) || "6".equals(this.targetBytecode) || "1.6".equals(this.targetBytecode)) {
            if (this.groovyOlderThan(GROOVY_2_1_3)) {
                throw new IllegalArgumentException("Target bytecode " + this.targetBytecode + " requires Groovy " + GROOVY_2_1_3 + " or newer.");
            }
        } else if (!("5".equals(this.targetBytecode) || "1.5".equals(this.targetBytecode) || "4".equals(this.targetBytecode) || "1.4".equals(this.targetBytecode))) {
            throw new IllegalArgumentException("Unrecognized target bytecode: '" + this.targetBytecode + "'. This check can be skipped with 'skipBytecodeCheck', but this may result in a different target bytecode being used.");
        }
    }

    protected static String translateJavacTargetToTargetBytecode(String targetBytecode) {
        HashMap<String, String> javacTargetToTargetBytecode = new HashMap<String, String>();
        javacTargetToTargetBytecode.put("5", "1.5");
        javacTargetToTargetBytecode.put("6", "1.6");
        javacTargetToTargetBytecode.put("7", "1.7");
        javacTargetToTargetBytecode.put("8", "1.8");
        javacTargetToTargetBytecode.put("1.9", "9");
        return javacTargetToTargetBytecode.getOrDefault(targetBytecode, targetBytecode);
    }
}

