/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.integration.internal;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jdt.groovy.integration.ISupplementalIndexer;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryGroovySupplementalIndexer
implements ISupplementalIndexer {
    @Override
    public List<char[]> extractNamedReferences(byte[] contents, ClassFileReader reader) {
        int[] constantPoolOffsets = reader.getConstantPoolOffsets();
        int constantPoolCount = constantPoolOffsets.length;
        ArrayList<char[]> refs = new ArrayList<char[]>();
        int i = 1;
        while (i < constantPoolCount) {
            int tag = reader.u1At(constantPoolOffsets[i]);
            switch (tag) {
                case 1: {
                    char[][] splits;
                    char[] strConst = this.extractStringConstant(constantPoolOffsets, reader, i);
                    if (!this.isValidId(strConst)) break;
                    char[][] cArray = splits = CharOperation.splitOn('.', strConst);
                    int n = splits.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char[] split = cArray[n2];
                        refs.add(split);
                        ++n2;
                    }
                    break;
                }
            }
            ++i;
        }
        return refs;
    }

    private boolean isValidId(char[] strConst) {
        if (strConst == null || strConst.length == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(strConst[0]) && strConst[0] != '.' || strConst[0] == '$') {
            return false;
        }
        int i = 1;
        while (i < strConst.length) {
            if (!Character.isJavaIdentifierPart(strConst[i]) && strConst[i] != '.' || strConst[i] == '$') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private char[] extractStringConstant(int[] constantPoolOffsets, ClassFileReader reader, int index) {
        int strlen = reader.u2At(constantPoolOffsets[index] + 1);
        int strstart = constantPoolOffsets[index] + 3;
        return reader.utf8At(strstart, strlen);
    }
}

