/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.maven.gossip.config;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.maven.gossip.InternalLogger;
import org.codehaus.groovy.maven.gossip.config.ConfigurationException;

public final class Context
implements Cloneable {
    private final InternalLogger log = InternalLogger.getLogger(this.getClass());
    private Map store;
    private String prefix;
    private Context parent;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Context(Map store, String prefix) {
        if (!$assertionsDisabled && store == null) {
            throw new AssertionError();
        }
        this.store = store;
        this.prefix = prefix;
    }

    public Context(Map store) {
        this(store, null);
    }

    public Context() {
        this(new HashMap(), null);
    }

    public Context(Context config) {
        this(config.store, config.prefix);
    }

    public String toString() {
        if (this.prefix == null) {
            return "Context[]";
        }
        return "Context[" + this.prefix + "]";
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void dump() {
        this.dump("    ");
    }

    void dump(String pad) {
        if (!$assertionsDisabled && pad == null) {
            throw new AssertionError();
        }
        Iterator iter = this.store.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Object value = this.store.get(name);
            this.log.debug("{}{}={}", new Object[]{pad, name, value});
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String key(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (this.prefix != null) {
            return this.prefix + "." + name;
        }
        return name;
    }

    public boolean contains(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        return this.store.containsKey(this.key(name));
    }

    public Object set(String name, Object value) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        return this.store.put(this.key(name), value);
    }

    public Object get(String name, Object defaultValue) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        Object value = this.store.get(this.key(name));
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public Object get(String name) {
        return this.get(name, (Object)null);
    }

    public Object remove(String name) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        return this.store.remove(this.key(name));
    }

    public void clear() {
        this.store.clear();
    }

    public int size() {
        if (this.prefix == null) {
            return this.store.size();
        }
        int c = 0;
        Iterator iter = this.store.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(this.prefix)) continue;
            ++c;
        }
        return c;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set names() {
        if (this.prefix == null) {
            return Collections.unmodifiableSet(this.store.keySet());
        }
        HashSet<String> matching = new HashSet<String>();
        int l = this.prefix.length();
        Iterator iter = this.store.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(this.prefix + ".")) continue;
            key = key.substring(l + 1, key.length());
            matching.add(key);
        }
        return Collections.unmodifiableSet(matching);
    }

    public Context parent() {
        if (this.parent == null) {
            throw new IllegalStateException("Parent is not bound");
        }
        return this.parent;
    }

    public Context child(String prefix) {
        if (!$assertionsDisabled && prefix == null) {
            throw new AssertionError();
        }
        Context child = (Context)this.clone();
        child.parent = this;
        child.prefix = child.prefix != null ? child.prefix + "." + prefix : prefix;
        return child;
    }

    public Object set(String name, boolean value) {
        return this.set(name, (Object)value);
    }

    public boolean get(String name, boolean defaultValue) {
        Object value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf(String.valueOf(value));
    }

    public Object set(String name, int value) {
        return this.set(name, new Integer(value));
    }

    public int get(String name, int defaultValue) {
        Object value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.valueOf(String.valueOf(value));
    }

    public String get(String name, String defaultValue) {
        Object value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return String.valueOf(value);
    }

    public File get(String name, File defaultValue) {
        Object value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof File) {
            return (File)value;
        }
        return new File(String.valueOf(value));
    }

    public URL get(String name, URL defaultValue) {
        Object value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof URL) {
            return (URL)value;
        }
        try {
            return new URL(String.valueOf(value));
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Unable to decode URL; name=" + name + ", value=" + value, e);
        }
    }

    public URI get(String name, URI defaultValue) {
        Object value = this.get(name);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof URI) {
            return (URI)value;
        }
        try {
            return new URI(String.valueOf(value));
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Unable to decode URI; name=" + name + ", value=" + value, e);
        }
    }

    static {
        $assertionsDisabled = !Context.class.desiredAssertionStatus();
    }
}

