/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.maven.gossip.model.source;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.groovy.maven.gossip.config.ConfigurationException;
import org.codehaus.groovy.maven.gossip.config.MissingPropertyException;
import org.codehaus.groovy.maven.gossip.model.Configuration;
import org.codehaus.groovy.maven.gossip.model.Source;

public class SystemPropertySource
extends Source {
    private String name;

    public SystemPropertySource() {
    }

    public SystemPropertySource(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Configuration load() throws Exception {
        URL url;
        String value;
        block5: {
            if (this.name == null) {
                throw new MissingPropertyException("name");
            }
            value = System.getProperty(this.name);
            if (value == null) {
                this.log.trace("Unable to load; property not set: {}", this.name);
                return null;
            }
            this.log.debug("Converting to URL: {}", value);
            url = null;
            try {
                url = new URL(value);
            }
            catch (MalformedURLException e) {
                File file = new File(value);
                if (!file.exists()) break block5;
                url = file.toURI().toURL();
            }
        }
        if (url == null) {
            throw new ConfigurationException("Unable to load; unable to resolve target: " + value);
        }
        return this.load(url);
    }

    public String toString() {
        return "SystemPropertySource{name='" + this.name + '\'' + '}';
    }
}

