/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jstestrunner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessLogger
extends Thread {
    private static Logger logger = Logger.getLogger(ProcessLogger.class.getName());
    private Process process;

    ProcessLogger(Process process) {
        this.process = process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        InputStreamReader inputStreamReader = new InputStreamReader(this.process.getInputStream());
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.toString());
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.toString());
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            try {
                int exitVal = this.process.waitFor();
                logger.log(Level.FINE, "Process exitValue: " + exitVal);
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "Problem waiting for completion." + e.toString());
            }
        }
    }
}

