/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer.enforcer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.PatternExcludesArtifactFilter;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.codehaus.mojo.animal_sniffer.ClassFileVisitor;
import org.codehaus.mojo.animal_sniffer.ClassListBuilder;
import org.codehaus.mojo.animal_sniffer.SignatureChecker;
import org.codehaus.mojo.animal_sniffer.enforcer.MavenLogger;
import org.codehaus.mojo.animal_sniffer.enforcer.Signature;
import org.codehaus.mojo.animal_sniffer.logging.Logger;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.StringUtils;

public class CheckSignatureRule
implements EnforcerRule {
    protected Signature signature;
    protected String[] ignores;
    protected String[] annotations;
    protected boolean ignoreDependencies = true;
    private String[] includeDependencies = null;
    private String[] excludeDependencies = null;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            File outputDirectory = new File((String)helper.evaluate("${project.build.outputDirectory}"));
            ArtifactResolver resolver = (ArtifactResolver)helper.getComponent(ArtifactResolver.class);
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            ArtifactRepository localRepository = (ArtifactRepository)helper.evaluate("${localRepository}");
            ArtifactFactory artifactFactory = (ArtifactFactory)helper.getComponent(ArtifactFactory.class);
            if (StringUtils.isEmpty((String)this.signature.getVersion())) {
                helper.getLog().debug((CharSequence)("Resolving signature " + this.signature.getGroupId() + ":" + this.signature.getArtifactId() + " version from dependencies"));
                String source = "dependencies";
                Dependency match = CheckSignatureRule.findMatchingDependency(this.signature, project.getDependencies());
                if (match == null) {
                    helper.getLog().debug((CharSequence)("Resolving signature " + this.signature.getGroupId() + ":" + this.signature.getArtifactId() + " version from dependencyManagement"));
                    source = "dependencyManagement";
                    match = CheckSignatureRule.findMatchingDependency(this.signature, project.getDependencyManagement().getDependencies());
                }
                if (match != null) {
                    helper.getLog().info((CharSequence)("Resolved signature " + this.signature.getGroupId() + ":" + this.signature.getArtifactId() + " version as " + match.getVersion() + " from " + source));
                    this.signature.setVersion(match.getVersion());
                }
            }
            helper.getLog().info((CharSequence)("Checking unresolved references to " + this.signature));
            Artifact a = this.signature.createArtifact(artifactFactory);
            resolver.resolve(a, project.getRemoteArtifactRepositories(), localRepository);
            MavenLogger logger = new MavenLogger(helper.getLog());
            Set<String> ignoredPackages = this.buildPackageList(outputDirectory, project, logger);
            if (this.ignores != null) {
                for (int i = 0; i < this.ignores.length; ++i) {
                    String ignore = this.ignores[i];
                    if (ignore == null) continue;
                    ignoredPackages.add(ignore.replace('.', '/'));
                }
            }
            SignatureChecker signatureChecker = new SignatureChecker((InputStream)new FileInputStream(a.getFile()), ignoredPackages, (Logger)logger);
            signatureChecker.setCheckJars(false);
            ArrayList<File> sourcePaths = new ArrayList<File>();
            for (String path : project.getCompileSourceRoots()) {
                sourcePaths.add(new File(path));
            }
            signatureChecker.setSourcePath(sourcePaths);
            if (this.annotations != null) {
                signatureChecker.setAnnotationTypes(Arrays.asList(this.annotations));
            }
            signatureChecker.process(outputDirectory);
            if (signatureChecker.isSignatureBroken()) {
                throw new EnforcerRuleException("Signature errors found. Verify them and ignore them with the proper annotation if needed.");
            }
        }
        catch (IOException e) {
            throw new EnforcerRuleException("Failed to check signatures", (Exception)e);
        }
        catch (AbstractArtifactResolutionException e) {
            throw new EnforcerRuleException("Failed to obtain signature: " + this.signature, (Exception)((Object)e));
        }
        catch (ComponentLookupException e) {
            throw new EnforcerRuleException("Unable to lookup a component " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    private static Dependency findMatchingDependency(Signature signature, List<Dependency> dependencies) {
        Dependency match = null;
        for (Dependency d : dependencies) {
            if (StringUtils.isEmpty((String)d.getVersion()) || !StringUtils.equals((String)d.getGroupId(), (String)signature.getGroupId()) || !StringUtils.equals((String)d.getArtifactId(), (String)signature.getArtifactId())) continue;
            if ("signature".equals(d.getType())) {
                match = d;
                break;
            }
            if ("pom".equals(d.getType()) && (match == null || "jar".equals(match.getType()))) {
                match = d;
            }
            if (!"jar".equals(d.getType()) || match != null) continue;
            match = d;
        }
        return match;
    }

    private Set<String> buildPackageList(File outputDirectory, MavenProject project, Logger logger) throws IOException {
        ClassListBuilder plb = new ClassListBuilder(logger);
        this.apply((ClassFileVisitor)plb, outputDirectory, project, logger);
        return plb.getPackages();
    }

    private void apply(ClassFileVisitor v, File outputDirectory, MavenProject project, Logger logger) throws IOException {
        v.process(outputDirectory);
        if (this.ignoreDependencies) {
            PatternIncludesArtifactFilter includesFilter = this.includeDependencies == null ? null : new PatternIncludesArtifactFilter(Arrays.asList(this.includeDependencies));
            PatternExcludesArtifactFilter excludesFilter = this.excludeDependencies == null ? null : new PatternExcludesArtifactFilter(Arrays.asList(this.excludeDependencies));
            logger.debug("Building list of classes from dependencies");
            for (Artifact artifact : project.getArtifacts()) {
                if (!artifact.getArtifactHandler().isAddedToClasspath()) {
                    logger.debug("Skipping artifact " + CheckSignatureRule.artifactId(artifact) + " as it is not added to the classpath.");
                    continue;
                }
                if (!("compile".equals(artifact.getScope()) || "provided".equals(artifact.getScope()) || "system".equals(artifact.getScope()))) {
                    logger.debug("Skipping artifact " + CheckSignatureRule.artifactId(artifact) + " as it is not on the compile classpath.");
                    continue;
                }
                if (includesFilter != null && !includesFilter.include(artifact)) {
                    logger.debug("Skipping classes in artifact " + CheckSignatureRule.artifactId(artifact) + " as it does not match include rules.");
                    continue;
                }
                if (excludesFilter != null && !excludesFilter.include(artifact)) {
                    logger.debug("Skipping classes in artifact " + CheckSignatureRule.artifactId(artifact) + " as it does matches exclude rules.");
                    continue;
                }
                if (artifact.getFile() == null) {
                    logger.warn("Skipping classes in artifact " + CheckSignatureRule.artifactId(artifact) + " as there are unresolved dependencies.");
                    continue;
                }
                logger.debug("Adding classes in artifact " + CheckSignatureRule.artifactId(artifact) + " to the ignores");
                v.process(artifact.getFile());
            }
        }
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule enforcerRule) {
        return false;
    }

    public String getCacheId() {
        return this.getClass().getName() + new Random().nextLong();
    }

    private static String artifactId(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + (artifact.getClassifier() != null ? ":" + artifact.getClassifier() : "") + ":" + artifact.getBaseVersion();
    }
}

