/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.DriverExecutionException;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Token;
import org.apache.cassandra.cql3.CqlLexer;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.cassandra.AbstractCassandraMojo;
import org.codehaus.mojo.cassandra.CqlExecutionException;
import org.codehaus.mojo.cassandra.CqlOperation;
import org.codehaus.mojo.cassandra.Utils;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractCqlExecMojo
extends AbstractCassandraMojo {
    @Parameter(property="cql.version", defaultValue="3.11.12")
    private String cqlVersion = "3.11.12";
    @Parameter(property="cql.encoding")
    protected String cqlEncoding = Charset.defaultCharset().name();
    @Parameter(defaultValue="false")
    protected boolean useCqlLexer = false;

    protected String readFile(File file) throws MojoExecutionException {
        String string;
        if (!file.isFile() || !file.exists()) {
            throw new MojoExecutionException("script " + file + " does not exist.");
        }
        InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(file), this.cqlEncoding);
        try {
            string = IOUtil.toString((Reader)r);
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException("Cql file '" + file + "' was deleted before I could read it", (Exception)e);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not parse or load cql file", (Exception)e);
            }
        }
        r.close();
        return string;
    }

    protected List<Row> executeCql(String statements) throws MojoExecutionException {
        ArrayList<Row> results = new ArrayList<Row>();
        if (StringUtils.isBlank((CharSequence)statements)) {
            this.getLog().warn((CharSequence)"No CQL provided. Nothing to do.");
        } else {
            try {
                CqlExecOperation cqlExecOperation = new CqlExecOperation(statements);
                Utils.executeCql(cqlExecOperation);
                results.addAll(cqlExecOperation.results);
            }
            catch (DriverExecutionException e) {
                throw new MojoExecutionException(e.getCause().getMessage(), (Exception)((Object)e));
            }
        }
        return results;
    }

    protected static List<String> splitStatementsUsingCqlLexer(String statements) {
        ANTLRStringStream stream = new ANTLRStringStream(statements);
        CqlLexer lexer = new CqlLexer((CharStream)stream);
        ArrayList<String> statementList = new ArrayList<String>();
        StringBuilder currentStatement = new StringBuilder();
        Token token = lexer.nextToken();
        while (token.getType() != -1) {
            if (token.getText().equals(";")) {
                currentStatement.append(";");
                statementList.add(currentStatement.toString());
                currentStatement = new StringBuilder();
            } else if (token.getType() == 188) {
                currentStatement.append("'");
                currentStatement.append(token.getText().replaceAll("'", "''"));
                currentStatement.append("'");
            } else if (token.getType() != 8) {
                currentStatement.append(token.getText());
            }
            token = lexer.nextToken();
        }
        if (currentStatement.length() > 0 && currentStatement.toString().trim().length() > 0) {
            statementList.add(currentStatement.toString());
        }
        return statementList;
    }

    private class CqlExecOperation
    extends CqlOperation {
        private final List<Row> results;
        private final List<String> statements;

        private CqlExecOperation(String statements) {
            super(AbstractCqlExecMojo.this.rpcAddress, AbstractCqlExecMojo.this.nativeTransportPort);
            this.results = new ArrayList<Row>();
            if (AbstractCqlExecMojo.this.useCqlLexer) {
                AbstractCqlExecMojo.this.getLog().warn((CharSequence)"Using CqlLexer has not been extensively tested");
                this.statements = AbstractCqlExecMojo.splitStatementsUsingCqlLexer(statements);
            } else {
                this.statements = Arrays.asList(statements.split(";"));
            }
            if (StringUtils.isNotBlank((CharSequence)AbstractCqlExecMojo.this.keyspace)) {
                AbstractCqlExecMojo.this.getLog().info((CharSequence)("setting keyspace: " + AbstractCqlExecMojo.this.keyspace));
                this.setKeyspace(AbstractCqlExecMojo.this.keyspace);
            }
            AbstractCqlExecMojo.this.getLog().info((CharSequence)("setting cqlversion: " + AbstractCqlExecMojo.this.cqlVersion));
            this.setCqlVersion(AbstractCqlExecMojo.this.cqlVersion);
        }

        @Override
        void executeOperation(CqlSession cqlSession) throws CqlExecutionException {
            for (String statement : this.statements) {
                if (!StringUtils.isNotBlank((CharSequence)statement)) continue;
                if (AbstractCqlExecMojo.this.getLog().isDebugEnabled()) {
                    AbstractCqlExecMojo.this.getLog().debug((CharSequence)("Executing cql statement: " + statement));
                }
                try {
                    ResultSet resultSet = cqlSession.execute(statement);
                    this.results.addAll(resultSet.all());
                }
                catch (Exception e) {
                    AbstractCqlExecMojo.this.getLog().debug((CharSequence)statement);
                    throw new CqlExecutionException(e);
                }
            }
        }
    }
}

