/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.changelog;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.maven.changelog.ChangeLog;
import org.apache.maven.changelog.ChangeLogEntry;
import org.apache.maven.changelog.ChangeLogFile;
import org.apache.maven.changelog.ChangeLogSet;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;

public class ChangeLogReport
extends AbstractMavenReport {
    private String type;
    private List ranges;
    private List dates;
    private List tags;
    private String dateFormat;
    private File basedir;
    private File outputXML;
    private String commentFormat;
    private String outputEncoding;
    private String scmUrl;
    private MavenProject project;
    private File outputDirectory;
    private SiteRenderer siteRenderer;
    private String rpt_Repository;
    private String rpt_OneRepoParam;
    private String rpt_MultiRepoParam;
    private String connection;

    public void executeReport(Locale locale) throws MavenReportException {
        if (!this.basedir.exists()) {
            this.doGenerateEmptyReport(this.getBundle(locale), this.getSink());
            return;
        }
        this.verifySCMTypeParams();
        Collection changedSets = this.getChangedSets();
        this.doGenerateReport(changedSets, this.getBundle(locale), this.getSink());
    }

    protected Collection getChangedSets() throws MavenReportException {
        Collection changedSets;
        try {
            FileInputStream fIn = new FileInputStream(this.outputXML);
            changedSets = ChangeLog.loadChangedSets(fIn, this.dateFormat);
        }
        catch (FileNotFoundException fnfe) {
            this.getLog().info((CharSequence)("Generating changed sets xml to: " + this.outputXML.getAbsolutePath()));
            changedSets = this.generateChangeSetsFromSCM();
        }
        catch (Exception e) {
            throw new MavenReportException("An error occurred while parsing " + this.outputXML.getAbsolutePath(), e);
        }
        return changedSets;
    }

    protected Collection generateChangeSetsFromSCM() throws MavenReportException {
        try {
            ChangeLog changeLog = this.getChangeLog();
            return changeLog.getChangeSets();
        }
        catch (IOException ioe) {
            throw new MavenReportException("An error occurred while generating " + this.outputXML.getAbsolutePath(), (Exception)ioe);
        }
    }

    protected ChangeLog getChangeLog() throws MavenReportException, IOException {
        ChangeLog changeLog = new ChangeLog();
        ChangeLog.setLog(this.getLog());
        changeLog.setBasedir(this.basedir);
        changeLog.setDevelopers(this.getProject().getDevelopers());
        changeLog.setOutput(this.outputXML);
        changeLog.setOutputEncoding(this.outputEncoding);
        changeLog.setType(this.type);
        changeLog.setRange(this.getDelimitedString(this.ranges));
        changeLog.setDate(this.getDelimitedString(this.dates));
        changeLog.setTag(this.getDelimitedString(this.tags));
        changeLog.setRepositoryConnection(this.getConnection());
        changeLog.setDateFormat(this.dateFormat);
        changeLog.setCommentFormat(this.commentFormat);
        changeLog.doExecute();
        return changeLog;
    }

    private String getDelimitedString(List list) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return "";
        }
        String retValue = "";
        Iterator i = list.iterator();
        while (i.hasNext()) {
            retValue = retValue + "," + (String)i.next();
        }
        return retValue.substring(1);
    }

    protected String getConnection() throws MavenReportException {
        if (this.connection != null) {
            return this.connection;
        }
        if (this.project.getScm() == null) {
            throw new MavenReportException("SCM Connection is not set.");
        }
        this.connection = this.project.getScm().getConnection();
        if (this.connection != null && this.connection.length() > 0) {
            return this.connection;
        }
        this.connection = this.project.getScm().getDeveloperConnection();
        if (this.connection == null) {
            throw new MavenReportException("SCM Connection is not set.");
        }
        if (this.connection.length() == 0) {
            throw new MavenReportException("SCM Connection is not set.");
        }
        return this.connection;
    }

    private void verifySCMTypeParams() throws MavenReportException {
        if ("range".equals(this.type)) {
            if (this.ranges == null) {
                this.ranges = Collections.singletonList("30");
            }
        } else if ("date".equals(this.type)) {
            if (this.dates == null) {
                throw new MavenReportException("The date parameter is required when type=\"date\". The value should be the absolute date for the start of the log.");
            }
        } else if ("tag".equals(this.type)) {
            if (this.tags == null) {
                throw new MavenReportException("The tag parameter is required when type=\"tag\".  The value should be the value of the tag for the start of the log.");
            }
        } else {
            throw new MavenReportException("The type parameter has an invalid value: " + this.type + ".  The value should be \"range\", \"date\", or \"tag\".");
        }
    }

    protected void doGenerateEmptyReport(ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.changelog.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.changelog.mainTitle"));
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text("No sources found to create a report.");
        sink.paragraph_();
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    protected void doGenerateReport(Collection changeSets, ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.changelog.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.changelog.mainTitle"));
        sink.sectionTitle1_();
        this.doSummarySection(changeSets, bundle, sink);
        sink.section1_();
        Iterator i = changeSets.iterator();
        while (i.hasNext()) {
            ChangeLogSet set = (ChangeLogSet)i.next();
            this.doChangedSet(set, bundle, sink);
        }
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void doSummarySection(Collection changeSets, ResourceBundle bundle, Sink sink) {
        sink.paragraph();
        sink.text(bundle.getString("report.changelog.ChangedSetsTotal"));
        sink.text(": " + changeSets.size());
        sink.paragraph_();
    }

    private void doChangedSet(ChangeLogSet set, ResourceBundle bundle, Sink sink) {
        sink.section1();
        sink.sectionTitle2();
        if (set.getStart() == null) {
            sink.text(bundle.getString("report.SetRangeUnknown"));
        } else if (set.getEnd() == null) {
            sink.text(bundle.getString("report.SetRangeSince"));
        } else {
            sink.text(bundle.getString("report.SetRangeBetween"));
            sink.text(" " + set.getStart() + " " + bundle.getString("report.To") + " " + set.getEnd());
        }
        sink.sectionTitle2_();
        sink.paragraph();
        sink.text(bundle.getString("report.TotalCommits"));
        sink.text(": " + set.getEntries().size());
        sink.lineBreak();
        sink.text(bundle.getString("report.changelog.FilesChanged"));
        sink.text(": " + this.countFilesChanged(set.getEntries()));
        sink.paragraph_();
        this.doChangedSetTable(set.getEntries(), bundle, sink);
        sink.section1_();
    }

    protected long countFilesChanged(Collection entries) {
        if (entries == null) {
            return 0L;
        }
        if (entries.isEmpty()) {
            return 0L;
        }
        HashMap<String, LinkedList> fileList = new HashMap<String, LinkedList>();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            ChangeLogEntry entry = (ChangeLogEntry)i.next();
            Vector files = entry.getFiles();
            Enumeration e = files.elements();
            while (e.hasMoreElements()) {
                LinkedList list;
                ChangeLogFile file = (ChangeLogFile)e.nextElement();
                String name = file.getName();
                if (fileList.containsKey(name)) {
                    list = (LinkedList)fileList.get(name);
                    list.add(file);
                    continue;
                }
                list = new LinkedList();
                list.add(file);
                fileList.put(name, list);
            }
        }
        return fileList.size();
    }

    private void doChangedSetTable(Collection entries, ResourceBundle bundle, Sink sink) {
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.changelog.timestamp"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.changelog.author"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.changelog.details"));
        sink.tableHeaderCell_();
        sink.tableRow_();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            ChangeLogEntry entry = (ChangeLogEntry)i.next();
            this.doChangedSetDetail(entry, bundle, sink);
        }
        sink.table_();
    }

    private void doChangedSetDetail(ChangeLogEntry entry, ResourceBundle bundle, Sink sink) {
        sink.tableRow();
        sink.tableCell();
        sink.text(entry.getDateFormatted() + " " + entry.getTimeFormatted());
        sink.tableCell_();
        sink.tableCell();
        sink.text(entry.getAuthor());
        sink.tableCell_();
        sink.tableCell();
        this.initReportUrls();
        this.doChangedFiles(entry.getFiles(), sink);
        sink.lineBreak();
        sink.text(entry.getComment());
        sink.tableCell_();
        sink.tableRow_();
    }

    protected void initReportUrls() {
        if (this.scmUrl != null) {
            int idx = this.scmUrl.indexOf(63);
            if (idx > 0) {
                this.rpt_Repository = this.scmUrl.substring(0, idx);
                String rpt_TmpMultiRepoParam = this.scmUrl.substring(this.rpt_Repository.length());
                this.rpt_OneRepoParam = "?" + rpt_TmpMultiRepoParam.substring(1);
                this.rpt_MultiRepoParam = "&" + rpt_TmpMultiRepoParam.substring(1);
            } else {
                this.rpt_Repository = this.scmUrl;
                this.rpt_OneRepoParam = "";
                this.rpt_MultiRepoParam = "";
            }
        }
    }

    private void doChangedFiles(Vector files, Sink sink) {
        Enumeration e = files.elements();
        while (e.hasMoreElements()) {
            ChangeLogFile file = (ChangeLogFile)e.nextElement();
            this.sinkLogFile(sink, file.getName(), file.getRevision());
        }
    }

    private void sinkLogFile(Sink sink, String name, String revision) {
        sink.paragraph();
        try {
            String connection = this.getConnection();
            this.generateLinks(connection, name, revision, sink);
        }
        catch (Exception e) {
            this.getLog().debug((Throwable)e);
            sink.text(name + " v " + revision);
        }
        sink.paragraph_();
    }

    protected void generateLinks(String connection, String name, Sink sink) {
        this.generateLinks(connection, name, null, sink);
    }

    protected void generateLinks(String connection, String name, String revision, Sink sink) {
        String linkFile = null;
        String linkRev = null;
        if (this.rpt_Repository != null) {
            if (connection.startsWith("scm:perforce")) {
                String path = this.getAbsolutePath(this.rpt_Repository, name);
                linkFile = path + "?ac=22";
                if (revision != null) {
                    linkRev = path + "?ac=64&rev=" + revision;
                }
            } else if (connection.startsWith("scm:clearcase")) {
                String path = this.getAbsolutePath(this.rpt_Repository, name);
                linkFile = path + this.rpt_OneRepoParam;
            } else if (connection.indexOf("cvsmonitor.pl") > 0) {
                String module = this.rpt_OneRepoParam.replaceAll("^.*(&amp;module=.*?(?:&amp;|$)).*$", "$1");
                linkFile = this.rpt_Repository + "?cmd=viewBrowseFile" + module + "&file=" + name;
                if (revision != null) {
                    linkRev = this.rpt_Repository + "?cmd=viewBrowseVersion" + module + "&file=" + name + "&version=" + revision;
                }
            } else {
                String path = this.getAbsolutePath(this.rpt_Repository, name);
                linkFile = path + this.rpt_OneRepoParam;
                if (revision != null) {
                    linkRev = path + "?rev=" + revision + "&content-type=text/vnd.viewcvs-markup" + this.rpt_MultiRepoParam;
                }
            }
        }
        if (linkFile != null) {
            sink.link(linkFile);
            sink.text(name);
            sink.link_();
        } else {
            sink.text(name);
        }
        sink.text(" ");
        if (linkRev != null) {
            sink.link(linkRev);
            sink.text("v " + revision);
            sink.link_();
        } else if (revision != null) {
            sink.text("v " + revision);
        }
    }

    private String getAbsolutePath(String base, String target) {
        String baseToken;
        String absPath = "";
        StringTokenizer baseTokens = new StringTokenizer(base.replaceAll("\\\\", "/"), "/", true);
        StringTokenizer targetTokens = new StringTokenizer(target.replaceAll("\\\\", "/"), "/");
        String targetRoot = targetTokens.nextToken();
        while (baseTokens.hasMoreTokens() && !(baseToken = baseTokens.nextToken()).equals(targetRoot)) {
            absPath = absPath + baseToken;
        }
        return absPath + target.substring(1);
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public String getDescription(Locale locale) {
        return "Generated Changelog report from SCM";
    }

    public String getName(Locale locale) {
        return "changelog";
    }

    public String getOutputName() {
        return "changelog";
    }

    protected ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("scm-activity", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

