/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.changelog;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.changelog.ChangeLogEntry;
import org.apache.maven.changelog.ChangeLogFile;
import org.apache.maven.changelog.ChangeLogReport;
import org.apache.maven.changelog.ChangeLogSet;
import org.apache.maven.changelog.FileActivityComparator;
import org.codehaus.doxia.sink.Sink;

public class FileActivityReport
extends ChangeLogReport {
    public String getDescription(Locale locale) {
        return "Generate file activity report from SCM";
    }

    public String getName(Locale locale) {
        return "file-activity";
    }

    public String getOutputName() {
        return "file-activity";
    }

    protected void doGenerateEmptyReport(ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.file-activity.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.file-activity.mainTitle"));
        sink.sectionTitle1_();
        sink.paragraph();
        sink.text("No sources found to create a report.");
        sink.paragraph_();
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    protected void doGenerateReport(Collection changeSets, ResourceBundle bundle, Sink sink) {
        sink.head();
        sink.title();
        sink.text(bundle.getString("report.file-activity.header"));
        sink.title_();
        sink.head_();
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text(bundle.getString("report.file-activity.mainTitle"));
        sink.sectionTitle1_();
        Iterator i = changeSets.iterator();
        while (i.hasNext()) {
            ChangeLogSet set = (ChangeLogSet)i.next();
            this.doChangedSets(set, bundle, sink);
        }
        sink.section1_();
        sink.body_();
        sink.table_();
    }

    private void doChangedSets(ChangeLogSet set, ResourceBundle bundle, Sink sink) {
        sink.section2();
        sink.sectionTitle2();
        if (set.getStart() == null) {
            sink.text(bundle.getString("report.SetRangeUnknown"));
        } else if (set.getEnd() == null) {
            sink.text(bundle.getString("report.SetRangeSince"));
        } else {
            sink.text(bundle.getString("report.SetRangeBetween"));
            sink.text(" " + set.getStart() + " " + bundle.getString("report.To") + " " + set.getEnd());
        }
        sink.sectionTitle2_();
        this.doSummary(set, bundle, sink);
        sink.table();
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.file-activity.filename"));
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text(bundle.getString("report.file-activity.timesChanged"));
        sink.tableHeaderCell_();
        sink.tableRow_();
        this.doRows(set, sink);
        sink.table_();
        sink.section2_();
    }

    private void doSummary(ChangeLogSet set, ResourceBundle bundle, Sink sink) {
        sink.paragraph();
        sink.text(bundle.getString("report.file-activity.range"));
        sink.text(": " + set.getStart() + " " + bundle.getString("report.To") + " " + set.getEnd());
        sink.text(", " + bundle.getString("report.TotalCommits"));
        sink.text(":" + set.getEntries().size());
        sink.text(", " + bundle.getString("report.file-activity.filesChanged"));
        sink.text(":" + this.countFilesChanged(set.getEntries()));
        sink.paragraph_();
    }

    private void doRows(ChangeLogSet set, Sink sink) {
        List list = this.getOrderedFileList(set.getEntries());
        this.initReportUrls();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            List revision = (List)i.next();
            ChangeLogFile file = (ChangeLogFile)revision.get(0);
            sink.tableRow();
            sink.tableCell();
            try {
                this.generateLinks(this.getConnection(), file.getName(), sink);
            }
            catch (Exception e) {
                e.printStackTrace();
                sink.text(file.getName());
            }
            sink.tableCell_();
            sink.tableCell();
            sink.text("" + revision.size());
            sink.tableCell_();
            sink.tableRow_();
        }
    }

    private List getOrderedFileList(Collection entries) {
        LinkedList list = new LinkedList();
        HashMap map = new HashMap();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            ChangeLogEntry entry = (ChangeLogEntry)i.next();
            Enumeration e = entry.getFiles().elements();
            while (e.hasMoreElements()) {
                ChangeLogFile file = (ChangeLogFile)e.nextElement();
                List<ChangeLogFile> revisions = map.containsKey(file.getName()) ? (List)map.get(file.getName()) : new LinkedList<ChangeLogFile>();
                revisions.add(file);
                map.put(file.getName(), revisions);
            }
        }
        list.addAll(map.values());
        Collections.sort(list, new FileActivityComparator());
        return list;
    }
}

