/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.exec.AbstractExecMojo;
import org.codehaus.mojo.exec.AbstractProperty;
import org.codehaus.mojo.exec.ProjectProperties;
import org.codehaus.mojo.exec.Property;
import org.codehaus.mojo.exec.SystemExitException;
import org.codehaus.mojo.exec.SystemExitManager;
import org.codehaus.mojo.exec.URLClassLoaderBuilder;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.DependencyFilterUtils;

@Mojo(name="java", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class ExecJavaMojo
extends AbstractExecMojo {
    private static final String THREAD_STOP_UNAVAILABLE = "Thread.stop() is unavailable in this JRE version, cannot force-stop any threads";
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(required=true, property="exec.mainClass")
    private String mainClass;
    @Parameter(property="exec.preloadCommonPool", defaultValue="0")
    private int preloadCommonPool;
    @Parameter(property="exec.arguments")
    private String[] arguments;
    @Parameter
    private AbstractProperty[] systemProperties;
    @Deprecated
    @Parameter(property="exec.keepAlive", defaultValue="false")
    private boolean keepAlive;
    @Parameter(property="exec.includeProjectDependencies", defaultValue="true")
    private boolean includeProjectDependencies;
    @Parameter(property="exec.includePluginsDependencies", defaultValue="false")
    private boolean includePluginDependencies;
    @Parameter(property="exec.cleanupDaemonThreads", defaultValue="true")
    private boolean cleanupDaemonThreads;
    @Parameter(property="exec.daemonThreadJoinTimeout", defaultValue="15000")
    private long daemonThreadJoinTimeout;
    @Parameter(property="exec.stopUnresponsiveDaemonThreads", defaultValue="false")
    private boolean stopUnresponsiveDaemonThreads;
    private Properties originalSystemProperties;
    @Parameter
    private List<String> additionalClasspathElements;
    @Parameter
    private List<String> classpathFilenameExclusions;
    @Parameter(property="exec.blockSystemExit", defaultValue="false")
    private boolean blockSystemExit;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"skipping execute as per configuration");
            return;
        }
        if (null == this.arguments) {
            this.arguments = new String[0];
        }
        if (this.getLog().isDebugEnabled()) {
            StringBuffer msg = new StringBuffer("Invoking : ");
            msg.append(this.mainClass);
            msg.append(".main(");
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    msg.append(", ");
                }
                msg.append(this.arguments[i]);
            }
            msg.append(")");
            this.getLog().debug((CharSequence)msg);
        }
        if (this.preloadCommonPool >= 0) {
            this.preloadCommonPool();
        }
        IsolatedThreadGroup threadGroup = new IsolatedThreadGroup(this.mainClass);
        Thread bootstrapThread = new Thread(threadGroup, () -> {
            int sepIndex = this.mainClass.indexOf(47);
            String bootClassName = sepIndex >= 0 ? this.mainClass.substring(sepIndex + 1) : this.mainClass;
            SecurityManager originalSecurityManager = System.getSecurityManager();
            try {
                Class<?> bootClass = Thread.currentThread().getContextClassLoader().loadClass(bootClassName);
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                MethodHandle mainHandle = lookup.findStatic(bootClass, "main", MethodType.methodType(Void.TYPE, String[].class));
                if (this.blockSystemExit) {
                    System.setSecurityManager(new SystemExitManager(originalSecurityManager));
                }
                mainHandle.invoke(this.arguments);
            }
            catch (IllegalAccessException | NoSuchMethodError | NoSuchMethodException e) {
                Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(), new Exception("The specified mainClass doesn't contain a main method with appropriate signature.", e));
            }
            catch (InvocationTargetException e) {
                Throwable exceptionToReport = e.getCause() != null ? e.getCause() : e;
                Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(), exceptionToReport);
            }
            catch (SystemExitException systemExitException) {
                this.getLog().info((CharSequence)systemExitException.getMessage());
                if (systemExitException.getExitCode() != 0) {
                    throw systemExitException;
                }
            }
            catch (Throwable e) {
                Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(), e);
            }
            finally {
                if (this.blockSystemExit) {
                    System.setSecurityManager(originalSecurityManager);
                }
            }
        }, this.mainClass + ".main()");
        URLClassLoader classLoader = this.getClassLoader();
        bootstrapThread.setContextClassLoader(classLoader);
        this.setSystemProperties();
        bootstrapThread.start();
        this.joinNonDaemonThreads(threadGroup);
        if (this.keepAlive) {
            this.getLog().warn((CharSequence)"Warning: keepAlive is now deprecated and obsolete. Do you need it? Please comment on MEXEC-6.");
            this.waitFor(0L);
        }
        if (this.cleanupDaemonThreads) {
            this.terminateThreads(threadGroup);
            try {
                threadGroup.destroy();
            }
            catch (IllegalThreadStateException e) {
                this.getLog().warn((CharSequence)("Couldn't destroy threadgroup " + threadGroup), (Throwable)e);
            }
        }
        if (classLoader != null) {
            try {
                classLoader.close();
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
        if (this.originalSystemProperties != null) {
            System.setProperties(this.originalSystemProperties);
        }
        IsolatedThreadGroup isolatedThreadGroup = threadGroup;
        synchronized (isolatedThreadGroup) {
            if (threadGroup.uncaughtException != null) {
                throw new MojoExecutionException("An exception occurred while executing the Java class. " + threadGroup.uncaughtException.getMessage(), threadGroup.uncaughtException);
            }
        }
        this.registerSourceRoots();
    }

    private void preloadCommonPool() {
        try {
            ForkJoinPool es = ForkJoinPool.commonPool();
            int max = this.preloadCommonPool > 0 ? this.preloadCommonPool : ForkJoinPool.getCommonPoolParallelism();
            CountDownLatch preLoad = new CountDownLatch(1);
            for (int i = 0; i < max; ++i) {
                es.submit(() -> {
                    try {
                        preLoad.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
            }
            preLoad.countDown();
        }
        catch (Exception e) {
            this.getLog().debug((CharSequence)(e.getMessage() + ", skipping commonpool earger init"));
        }
    }

    private void joinNonDaemonThreads(ThreadGroup threadGroup) {
        boolean foundNonDaemon;
        do {
            foundNonDaemon = false;
            Collection<Thread> threads = this.getActiveThreads(threadGroup);
            for (Thread thread : threads) {
                if (thread.isDaemon()) continue;
                foundNonDaemon = true;
                this.joinThread(thread, 0L);
            }
        } while (foundNonDaemon);
    }

    private void joinThread(Thread thread, long timeoutMsecs) {
        try {
            this.getLog().debug((CharSequence)("joining on thread " + thread));
            thread.join(timeoutMsecs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.getLog().warn((CharSequence)("interrupted while joining against thread " + thread), (Throwable)e);
        }
        if (thread.isAlive()) {
            this.getLog().warn((CharSequence)("thread " + thread + " was interrupted but is still alive after waiting at least " + timeoutMsecs + "msecs"));
        }
    }

    private void terminateThreads(ThreadGroup threadGroup) {
        long startTime = System.currentTimeMillis();
        HashSet<Thread> uncooperativeThreads = new HashSet<Thread>();
        Collection<Thread> threads = this.getActiveThreads(threadGroup);
        while (!threads.isEmpty()) {
            for (Thread thread : threads) {
                this.getLog().debug((CharSequence)("interrupting thread " + thread));
                thread.interrupt();
            }
            boolean threadStopIsAvailable = true;
            for (Thread thread : threads) {
                if (!thread.isAlive()) continue;
                if (this.daemonThreadJoinTimeout <= 0L) {
                    this.joinThread(thread, 0L);
                    continue;
                }
                long timeout = this.daemonThreadJoinTimeout - (System.currentTimeMillis() - startTime);
                if (timeout > 0L) {
                    this.joinThread(thread, timeout);
                }
                if (!thread.isAlive()) continue;
                uncooperativeThreads.add(thread);
                if (this.stopUnresponsiveDaemonThreads && threadStopIsAvailable) {
                    this.getLog().warn((CharSequence)("thread " + thread + " will be Thread.stop()'ed"));
                    try {
                        thread.stop();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        threadStopIsAvailable = false;
                        this.getLog().warn((CharSequence)THREAD_STOP_UNAVAILABLE);
                    }
                    continue;
                }
                this.getLog().warn((CharSequence)("thread " + thread + " will linger despite being asked to die via interruption"));
            }
            threads = this.getActiveThreads(threadGroup);
            threads.removeAll(uncooperativeThreads);
        }
        if (!uncooperativeThreads.isEmpty()) {
            this.getLog().warn((CharSequence)("NOTE: " + uncooperativeThreads.size() + " thread(s) did not finish despite being asked to via interruption. This is not a problem with exec:java, it is a problem with the running code. Although not serious, it should be remedied."));
        } else {
            int activeCount = threadGroup.activeCount();
            if (activeCount != 0) {
                Thread[] threadsArray = new Thread[1];
                threadGroup.enumerate(threadsArray);
                this.getLog().debug((CharSequence)("strange; " + activeCount + " thread(s) still active in the group " + threadGroup + " such as " + threadsArray[0]));
            }
        }
    }

    private Collection<Thread> getActiveThreads(ThreadGroup threadGroup) {
        Thread[] threads = new Thread[threadGroup.activeCount()];
        int numThreads = threadGroup.enumerate(threads);
        ArrayList<Thread> result = new ArrayList<Thread>(numThreads);
        for (int i = 0; i < threads.length && threads[i] != null; ++i) {
            result.add(threads[i]);
        }
        return result;
    }

    private void setSystemProperties() {
        if (this.systemProperties == null) {
            return;
        }
        this.originalSystemProperties = new Properties();
        this.originalSystemProperties.putAll((Map<?, ?>)System.getProperties());
        if (Stream.of(this.systemProperties).anyMatch(it -> it instanceof ProjectProperties)) {
            System.getProperties().putAll((Map<?, ?>)this.project.getProperties());
        }
        for (AbstractProperty systemProperty : this.systemProperties) {
            if (!(systemProperty instanceof Property)) continue;
            Property prop = (Property)systemProperty;
            String value = prop.getValue();
            System.setProperty(prop.getKey(), value == null ? "" : value);
        }
    }

    private URLClassLoader getClassLoader() throws MojoExecutionException {
        ArrayList<Path> classpathURLs = new ArrayList<Path>();
        this.addRelevantPluginDependenciesToClasspath(classpathURLs);
        this.addRelevantProjectDependenciesToClasspath(classpathURLs);
        this.addAdditionalClasspathElements(classpathURLs);
        try {
            return URLClassLoaderBuilder.builder().setLogger(this.getLog()).setPaths(classpathURLs).setExclusions(this.classpathFilenameExclusions).build();
        }
        catch (IOException | NullPointerException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void addAdditionalClasspathElements(List<Path> path) {
        if (this.additionalClasspathElements != null) {
            for (String classPathElement : this.additionalClasspathElements) {
                Path file = Paths.get(classPathElement, new String[0]);
                if (!file.isAbsolute()) {
                    file = this.project.getBasedir().toPath().resolve(file);
                }
                this.getLog().debug((CharSequence)("Adding additional classpath element: " + file + " to classpath"));
                path.add(file);
            }
        }
    }

    private void addRelevantPluginDependenciesToClasspath(List<Path> path) throws MojoExecutionException {
        if (this.hasCommandlineArgs()) {
            this.arguments = this.parseCommandlineArgs();
        }
        for (Artifact classPathElement : this.determineRelevantPluginDependencies()) {
            this.getLog().debug((CharSequence)("Adding plugin dependency artifact: " + classPathElement.getArtifactId() + " to classpath"));
            path.add(classPathElement.getFile().toPath());
        }
    }

    private void addRelevantProjectDependenciesToClasspath(List<Path> path) {
        if (this.includeProjectDependencies) {
            this.getLog().debug((CharSequence)"Project Dependencies will be included.");
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
            ArrayList<Path> theClasspathFiles = new ArrayList<Path>();
            this.collectProjectArtifactsAndClasspath(artifacts, theClasspathFiles);
            for (Path classpathFile : theClasspathFiles) {
                this.getLog().debug((CharSequence)("Adding to classpath : " + classpathFile));
                path.add(classpathFile);
            }
            for (Artifact classPathElement : artifacts) {
                this.getLog().debug((CharSequence)("Adding project dependency artifact: " + classPathElement.getArtifactId() + " to classpath"));
                path.add(classPathElement.getFile().toPath());
            }
        } else {
            this.getLog().debug((CharSequence)"Project Dependencies will be excluded.");
        }
    }

    private Set<Artifact> determineRelevantPluginDependencies() throws MojoExecutionException {
        Set<Artifact> relevantDependencies;
        if (this.includePluginDependencies) {
            if (this.executableDependency == null) {
                this.getLog().debug((CharSequence)"All Plugin Dependencies will be included.");
                relevantDependencies = new HashSet<Artifact>(this.getPluginDependencies());
            } else {
                this.getLog().debug((CharSequence)"Selected plugin Dependencies will be included.");
                Artifact executableArtifact = this.findExecutableArtifact();
                relevantDependencies = this.resolveExecutableDependencies(executableArtifact);
            }
        } else {
            relevantDependencies = Collections.emptySet();
            this.getLog().debug((CharSequence)"Plugin Dependencies will be excluded.");
        }
        return relevantDependencies;
    }

    private Set<Artifact> resolveExecutableDependencies(Artifact executableArtifact) throws MojoExecutionException {
        try {
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(new Dependency(RepositoryUtils.toArtifact((Artifact)executableArtifact), this.classpathScope));
            collectRequest.setRepositories(this.project.getRemotePluginRepositories());
            DependencyFilter classpathFilter = DependencyFilterUtils.classpathFilter((String[])new String[]{this.classpathScope});
            DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, classpathFilter);
            DependencyResult dependencyResult = this.repositorySystem.resolveDependencies(this.getSession().getRepositorySession(), dependencyRequest);
            return dependencyResult.getArtifactResults().stream().map(ArtifactResult::getArtifact).map(RepositoryUtils::toArtifact).collect(Collectors.toSet());
        }
        catch (DependencyResolutionException ex) {
            throw new MojoExecutionException("Encountered problems resolving dependencies of the executable in preparation for its execution.", (Exception)((Object)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitFor(long millis) {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait(millis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.getLog().warn((CharSequence)("Spuriously interrupted while waiting for " + millis + "ms"), (Throwable)e);
            }
        }
    }

    class IsolatedThreadGroup
    extends ThreadGroup {
        private Throwable uncaughtException;

        public IsolatedThreadGroup(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                return;
            }
            IsolatedThreadGroup isolatedThreadGroup = this;
            synchronized (isolatedThreadGroup) {
                if (this.uncaughtException == null) {
                    this.uncaughtException = throwable;
                }
            }
            ExecJavaMojo.this.getLog().warn(throwable);
        }
    }
}

