/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractStandardEnforcerRule;
import org.apache.maven.plugins.enforcer.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BanDuplicateClasses
extends AbstractStandardEnforcerRule {
    private String[] ignoreClasses;
    private boolean findAllDuplicates;
    private List<Dependency> dependencies;
    private List<String> scopes;

    private static String asRegex(String wildcard) {
        StringBuilder result = new StringBuilder(wildcard.length());
        result.append('^');
        block5: for (int index = 0; index < wildcard.length(); ++index) {
            char character = wildcard.charAt(index);
            switch (character) {
                case '*': {
                    result.append(".*");
                    continue block5;
                }
                case '?': {
                    result.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    result.append("\\");
                }
                default: {
                    result.append(character);
                }
            }
        }
        result.append("(\\.class)?");
        result.append('$');
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        ArrayList<IgnorableDependency> ignorableDependencies = new ArrayList<IgnorableDependency>();
        if (this.ignoreClasses != null) {
            IgnorableDependency ignorableDependency = new IgnorableDependency();
            this.applyIgnoreClasses(ignorableDependency, this.ignoreClasses, log, false);
            ignorableDependencies.add(ignorableDependency);
        }
        if (this.dependencies != null) {
            for (Dependency dependency : this.dependencies) {
                log.info((CharSequence)("Adding ignorable dependency: " + dependency));
                IgnorableDependency ignorableDependency = new IgnorableDependency();
                if (dependency.getGroupId() != null) {
                    ignorableDependency.groupId = Pattern.compile(BanDuplicateClasses.asRegex(dependency.getGroupId()));
                }
                if (dependency.getArtifactId() != null) {
                    ignorableDependency.artifactId = Pattern.compile(BanDuplicateClasses.asRegex(dependency.getArtifactId()));
                }
                if (dependency.getType() != null) {
                    ignorableDependency.type = Pattern.compile(BanDuplicateClasses.asRegex(dependency.getType()));
                }
                if (dependency.getClassifier() != null) {
                    ignorableDependency.classifier = Pattern.compile(BanDuplicateClasses.asRegex(dependency.getClassifier()));
                }
                this.applyIgnoreClasses(ignorableDependency, dependency.getIgnoreClasses(), log, true);
                ignorableDependencies.add(ignorableDependency);
            }
        }
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            Set artifacts = project.getArtifacts();
            HashMap<String, Artifact> classNames = new HashMap<String, Artifact>();
            HashMap<String, Set<Artifact>> duplicates = new HashMap<String, Set<Artifact>>();
            for (Artifact o : artifacts) {
                if (this.scopes != null && !this.scopes.contains(o.getScope())) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((CharSequence)("Skipping " + o.toString() + " due to scope"));
                    continue;
                }
                File file = o.getFile();
                log.debug((CharSequence)("Searching for duplicate classes in " + file));
                if (file == null || !file.exists()) {
                    log.warn((CharSequence)("Could not find " + o + " at " + file));
                    continue;
                }
                if (file.isDirectory()) {
                    try {
                        for (String name : FileUtils.getFileNames((File)file, null, null, (boolean)false)) {
                            log.debug((CharSequence)("  " + name));
                            this.checkAndAddName(o, name, classNames, duplicates, ignorableDependencies, log);
                        }
                        continue;
                    }
                    catch (IOException e) {
                        throw new EnforcerRuleException("Unable to process dependency " + o.toString() + " due to " + e.getLocalizedMessage(), (Exception)e);
                    }
                }
                if (!file.isFile() || !"jar".equals(o.getType())) continue;
                try {
                    JarFile jar = new JarFile(file);
                    try {
                        for (JarEntry entry : Collections.list(jar.entries())) {
                            this.checkAndAddName(o, entry.getName(), classNames, duplicates, ignorableDependencies, log);
                        }
                    }
                    finally {
                        try {
                            jar.close();
                        }
                        catch (IOException e) {}
                    }
                }
                catch (IOException e) {
                    throw new EnforcerRuleException("Unable to process dependency " + o.toString() + " due to " + e.getLocalizedMessage(), (Exception)e);
                }
            }
            if (!duplicates.isEmpty()) {
                HashMap inverted = new HashMap();
                for (Map.Entry entry : duplicates.entrySet()) {
                    ArrayList s = (ArrayList)inverted.get(entry.getValue());
                    if (s == null) {
                        s = new ArrayList();
                    }
                    s.add(entry.getKey());
                    inverted.put(entry.getValue(), s);
                }
                StringBuilder buf = new StringBuilder(this.message == null ? "Duplicate classes found:" : this.message);
                buf.append('\n');
                for (Map.Entry entry : inverted.entrySet()) {
                    buf.append("\n  Found in:");
                    for (Artifact a : (Set)entry.getKey()) {
                        buf.append("\n    ");
                        buf.append(a);
                    }
                    buf.append("\n  Duplicate classes:");
                    for (String className : (List)entry.getValue()) {
                        buf.append("\n    ");
                        buf.append(className);
                    }
                    buf.append('\n');
                }
                throw new EnforcerRuleException(buf.toString());
            }
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    private void applyIgnoreClasses(IgnorableDependency ignorableDependency, String[] ignores, Log log, boolean indent) {
        String prefix = indent ? "  " : "";
        for (String ignore : ignores) {
            log.info((CharSequence)(prefix + "Adding ignore: " + ignore));
            ignore = ignore.replace('.', '/');
            String pattern = BanDuplicateClasses.asRegex(ignore);
            log.debug((CharSequence)(prefix + "Ignore: " + ignore + " maps to regex " + pattern));
            ignorableDependency.ignores.add(Pattern.compile(pattern));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkAndAddName(Artifact artifact, String name, Map<String, Artifact> classNames, Map<String, Set<Artifact>> duplicates, Collection<IgnorableDependency> ignores, Log log) throws EnforcerRuleException {
        if (!name.endsWith(".class")) {
            return;
        }
        if (!classNames.containsKey(name)) {
            classNames.put(name, artifact);
            return;
        }
        for (IgnorableDependency c : ignores) {
            if (!this.matchesArtifact(artifact, c)) continue;
            for (Pattern p : c.ignores) {
                if (!p.matcher(name).matches()) continue;
                log.debug((CharSequence)("Ignoring duplicate class " + name));
                return;
            }
        }
        Artifact dup = classNames.put(name, artifact);
        if (!this.findAllDuplicates || !duplicates.containsKey(name)) {
            for (IgnorableDependency c : ignores) {
                if (!this.matchesArtifact(artifact, c)) continue;
                for (Pattern p : c.ignores) {
                    if (!p.matcher(name).matches()) continue;
                    log.debug((CharSequence)("Ignoring duplicate class " + name));
                    return;
                }
            }
        }
        if (this.findAllDuplicates) {
            Set<Artifact> dups = duplicates.get(name);
            if (dups == null) {
                dups = new LinkedHashSet<Artifact>();
                dups.add(dup);
            }
            dups.add(artifact);
            duplicates.put(name, dups);
            return;
        }
        StringBuilder buf = new StringBuilder(this.message == null ? "Duplicate class found:" : this.message);
        buf.append('\n');
        buf.append("\n  Found in:");
        buf.append("\n    ");
        buf.append(dup);
        buf.append("\n    ");
        buf.append(artifact);
        buf.append("\n  Duplicate classes:");
        buf.append("\n    ");
        buf.append(name);
        buf.append('\n');
        buf.append("There may be others but <findAllDuplicates> was set to false, so failing fast");
        throw new EnforcerRuleException(buf.toString());
    }

    private boolean matchesArtifact(Artifact dup, IgnorableDependency c) {
        return !(c.artifactId != null && !c.artifactId.matcher(dup.getArtifactId()).matches() || c.groupId != null && !c.groupId.matcher(dup.getGroupId()).matches() || c.classifier != null && !c.classifier.matcher(dup.getClassifier()).matches() || c.type != null && !c.type.matcher(dup.getType()).matches());
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule enforcerRule) {
        return false;
    }

    public String getCacheId() {
        return "Does not matter as not cacheable";
    }

    private class IgnorableDependency {
        private Pattern groupId;
        private Pattern artifactId;
        private Pattern classifier;
        private Pattern type;
        private List<Pattern> ignores = new ArrayList<Pattern>();

        private IgnorableDependency() {
        }
    }
}

