/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractBanDependencies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnforceBytecodeVersion
extends AbstractBanDependencies {
    private static final Map<String, Integer> JDK_TO_MAJOR_VERSION_NUMBER_MAPPING = new HashMap<String, Integer>();
    private String maxJdkVersion;
    int maxJavaMajorVersionNumber = -1;
    int maxJavaMinorVersionNumber = 0;
    private EnforcerRuleHelper helper;

    public void execute(EnforcerRuleHelper pHelper) throws EnforcerRuleException {
        this.computeParameters();
        this.helper = pHelper;
        super.execute(this.helper);
    }

    private void computeParameters() throws EnforcerRuleException {
        if (this.maxJdkVersion != null && this.maxJavaMajorVersionNumber != -1) {
            throw new IllegalArgumentException("Only maxJdkVersion or maxJavaMajorVersionNumber configuration parameters should be set. Not both.");
        }
        if (this.maxJdkVersion == null && this.maxJavaMajorVersionNumber == -1) {
            throw new IllegalArgumentException("Exactly one of maxJdkVersion or maxJavaMajorVersionNumber options should be set.");
        }
        if (this.maxJdkVersion != null) {
            Integer needle = JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.get(this.maxJdkVersion);
            if (needle == null) {
                throw new IllegalArgumentException("Unknown JDK version given. Should be something like \"1.7\"");
            }
            this.maxJavaMajorVersionNumber = needle;
        }
        if (this.maxJavaMajorVersionNumber == -1) {
            throw new EnforcerRuleException("maxJavaMajorVersionNumber must be set in the plugin configuration");
        }
    }

    protected Set<Artifact> checkDependencies(Set dependencies, Log log) throws EnforcerRuleException {
        LinkedHashSet<Artifact> problematic = new LinkedHashSet<Artifact>();
        for (Artifact artifact : dependencies) {
            this.getLog().debug((CharSequence)("Analyzing artifact " + artifact));
            if (!this.isBadArtifact(artifact)) continue;
            this.getLog().info((CharSequence)("Artifact " + artifact + " contains .class compiled with incorrect version"));
            problematic.add(artifact);
        }
        return problematic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isBadArtifact(Artifact a) throws EnforcerRuleException {
        File f = a.getFile();
        if (!f.getName().endsWith(".jar")) {
            return false;
        }
        try {
            JarFile jarFile = new JarFile(f);
            try {
                block10: {
                    this.getLog().debug((CharSequence)(f.getName() + " => " + f.getPath()));
                    byte[] magicAndClassFileVersion = new byte[8];
                    Enumeration<JarEntry> e = jarFile.entries();
                    while (e.hasMoreElements()) {
                        JarEntry entry = e.nextElement();
                        if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                        StringBuilder builder = new StringBuilder();
                        builder.append("\t").append(entry.getName()).append(" => ");
                        InputStream is = jarFile.getInputStream(entry);
                        int read = is.read(magicAndClassFileVersion);
                        is.close();
                        assert (read != 8);
                        int minor = (magicAndClassFileVersion[4] << 8) + magicAndClassFileVersion[5];
                        int major = (magicAndClassFileVersion[6] << 8) + magicAndClassFileVersion[7];
                        builder.append("major=").append(major).append(",minor=").append(minor);
                        this.getLog().debug((CharSequence)builder.toString());
                        if (major <= this.maxJavaMajorVersionNumber && (major != this.maxJavaMajorVersionNumber || minor <= this.maxJavaMinorVersionNumber)) {
                            continue;
                        }
                        break block10;
                    }
                    return false;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                jarFile.close();
            }
        }
        catch (IOException e) {
            throw new EnforcerRuleException("Error while reading jar file", (Exception)e);
        }
    }

    private Log getLog() {
        return this.helper.getLog();
    }

    public void setMaxJavaMajorVersionNumber(int maxJavaMajorVersionNumber) {
        this.maxJavaMajorVersionNumber = maxJavaMajorVersionNumber;
    }

    public void setMaxJavaMinorVersionNumber(int maxJavaMinorVersionNumber) {
        this.maxJavaMinorVersionNumber = maxJavaMinorVersionNumber;
    }

    static {
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.1", 45);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.2", 46);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.3", 47);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.4", 48);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.5", 49);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.6", 50);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.7", 51);
        JDK_TO_MAJOR_VERSION_NUMBER_MAPPING.put("1.8", 52);
    }
}

