/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirePropertyDiverges
extends AbstractNonCacheableEnforcerRule {
    static final String MAVEN_ENFORCER_PLUGIN = "org.apache.maven.plugins:maven-enforcer-plugin";
    private String property = null;
    private String regex = null;
    private final String ruleName = StringUtils.lowercaseFirstLetter((String)((Object)((Object)this)).getClass().getSimpleName());

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        Object propValue = this.getPropertyValue(helper);
        this.checkPropValueNotBlank(propValue);
        MavenProject project = this.getMavenProject(helper);
        log.debug((CharSequence)(this.getRuleName() + ": checking property '" + this.property + "' for project " + project));
        MavenProject parent = this.findDefiningParent(project);
        if (project.equals((Object)parent)) {
            log.debug((CharSequence)(this.getRuleName() + ": skip for property '" + this.property + "' as " + project + " defines rule."));
        } else {
            log.debug((CharSequence)("Check configuration defined in " + parent));
            if (this.regex == null) {
                this.checkAgainstParentValue(project, parent, helper, propValue);
            } else {
                this.checkAgainstRegex(propValue);
            }
        }
    }

    void checkAgainstParentValue(MavenProject project, MavenProject parent, EnforcerRuleHelper helper, Object propValue) throws EnforcerRuleException {
        StringBuilder parentHierarchy = new StringBuilder("project.");
        MavenProject needle = project;
        while (!needle.equals((Object)parent)) {
            parentHierarchy.append("parent.");
            needle = needle.getParent();
        }
        String propertyNameInParent = this.property.replace("project.", parentHierarchy.toString());
        Object parentValue = this.getPropertyValue(helper, propertyNameInParent);
        if (propValue.equals(parentValue)) {
            String errorMessage = String.format("Property '%s' evaluates to '%s'. This does match '%s' from parent %s", this.property, propValue, parentValue, parent);
            throw new EnforcerRuleException(errorMessage);
        }
    }

    void checkAgainstRegex(Object propValue) throws EnforcerRuleException {
        if (propValue.toString().matches(this.regex)) {
            String errorMessage = String.format("Property '%s' evaluates to '%s'. This does match the regular expression '%s'", this.property, propValue, this.regex);
            throw new EnforcerRuleException(errorMessage);
        }
    }

    final MavenProject findDefiningParent(MavenProject project) {
        List<Xpp3Dom> rules;
        Model model;
        Build build;
        MavenProject parent;
        Xpp3Dom invokingRule = this.createInvokingRuleDom();
        for (parent = project; !(parent == null || (build = (model = parent.getOriginalModel()).getBuild()) != null && this.isDefiningProject(rules = this.getRuleConfigurations(build), invokingRule)); parent = parent.getParent()) {
        }
        return parent;
    }

    Xpp3Dom createInvokingRuleDom() {
        Xpp3Dom ruleDom = new Xpp3Dom(this.getRuleName());
        Xpp3Dom propertyDom = new Xpp3Dom("property");
        propertyDom.setValue(this.property);
        ruleDom.addChild(propertyDom);
        if (this.regex != null) {
            Xpp3Dom regexDom = new Xpp3Dom("regex");
            regexDom.setValue(this.regex);
            ruleDom.addChild(regexDom);
        }
        return ruleDom;
    }

    final boolean isDefiningProject(List<Xpp3Dom> rulesFromModel, Xpp3Dom invokingRule) {
        for (Xpp3Dom rule : rulesFromModel) {
            if (!rule.equals((Object)invokingRule)) continue;
            return true;
        }
        return false;
    }

    final String getRuleName() {
        return this.ruleName;
    }

    final List<Xpp3Dom> getRuleConfigurations(Build build) {
        Map plugins = build.getPluginsAsMap();
        List<Xpp3Dom> ruleConfigurationsForPlugins = this.getRuleConfigurations(plugins);
        PluginManagement pluginManagement = build.getPluginManagement();
        if (pluginManagement != null) {
            Map pluginsFromManagementAsMap = pluginManagement.getPluginsAsMap();
            List<Xpp3Dom> ruleConfigurationsFromManagement = this.getRuleConfigurations(pluginsFromManagementAsMap);
            ruleConfigurationsForPlugins.addAll(ruleConfigurationsFromManagement);
        }
        return ruleConfigurationsForPlugins;
    }

    List<Xpp3Dom> getRuleConfigurations(Map<String, Plugin> plugins) {
        if (plugins.containsKey(MAVEN_ENFORCER_PLUGIN)) {
            Plugin enforcer = plugins.get(MAVEN_ENFORCER_PLUGIN);
            Xpp3Dom configuration = (Xpp3Dom)enforcer.getConfiguration();
            if (configuration != null) {
                Xpp3Dom rules = configuration.getChild("rules");
                return Arrays.asList(rules.getChildren(this.getRuleName()));
            }
            return new ArrayList<Xpp3Dom>();
        }
        return Collections.emptyList();
    }

    Object getPropertyValue(EnforcerRuleHelper helper) throws EnforcerRuleException {
        return this.getPropertyValue(helper, this.property);
    }

    Object getPropertyValue(EnforcerRuleHelper helper, String propertyName) throws EnforcerRuleException {
        try {
            return helper.evaluate("${" + propertyName + "}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to evaluate property: " + propertyName, (Exception)((Object)eee));
        }
    }

    MavenProject getMavenProject(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            return (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to get project.", (Exception)((Object)eee));
        }
    }

    void checkPropValueNotBlank(Object propValue) throws EnforcerRuleException {
        if (propValue == null || StringUtils.isBlank((String)propValue.toString())) {
            throw new EnforcerRuleException(String.format("Property '%s' is required for this build and not defined in hierarchy at all.", this.property));
        }
    }

    void setProperty(String property) {
        this.property = property;
    }

    void setRegex(String regex) {
        this.regex = regex;
    }
}

