/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt.reports;

import java.io.File;
import java.util.Locale;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.surefire.booter.shade.org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.mojo.gwt.GwtRuntime;
import org.codehaus.mojo.gwt.shell.AbstractGwtShellMojo;

public class SoycReport
extends AbstractGwtShellMojo
implements MavenReport {
    protected File reportingOutputDirectory;
    private File extra;

    protected void doExecute(GwtRuntime runtime) throws MojoExecutionException, MojoFailureException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.extra);
        scanner.setIncludes(new String[]{"**/soycReport/stories0.xml.gz"});
        scanner.scan();
        if (scanner.getIncludedFiles().length == 0) {
            this.getLog().warn((CharSequence)"No SOYC raw report found, did you compile with soyc option set ?");
            return;
        }
        for (String path : scanner.getIncludedFiles()) {
            String module = path.substring(0, path.indexOf(File.separatorChar));
            AbstractGwtShellMojo.JavaCommand cmd = new AbstractGwtShellMojo.JavaCommand(this, "com.google.gwt.soyc.SoycDashboard", runtime).withinClasspath(runtime.getGwtDevJar()).withinClasspath(runtime.getSoycJar()).arg("-resources").arg(runtime.getSoycJar().getAbsolutePath()).arg("-out").arg(this.reportingOutputDirectory.getAbsolutePath() + File.separatorChar + module);
            cmd.arg(new File(this.extra, path).getAbsolutePath());
            cmd.arg(new File(this.extra, path).getAbsolutePath().replace("stories", "dependencies"));
            cmd.arg(new File(this.extra, path).getAbsolutePath().replace("stories", "splitPoints"));
            cmd.execute();
        }
    }

    public boolean canGenerateReport() {
        return true;
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        try {
            this.doExecute(this.getGwtRuntime());
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("Failed to execute SoycDashboard", (Exception)((Object)e));
        }
        catch (MojoFailureException e) {
            throw new MavenReportException("Failed to execute SoycDashboard", (Exception)((Object)e));
        }
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public String getDescription(Locale locale) {
        return "GWT Story Of Your Compiler";
    }

    public String getName(Locale locale) {
        return "GWT Story Of Your Compiler";
    }

    public String getOutputName() {
        return "soyc";
    }

    public File getReportOutputDirectory() {
        return this.reportingOutputDirectory;
    }

    public boolean isExternalReport() {
        return false;
    }

    public void setReportOutputDirectory(File outputDirectory) {
        this.reportingOutputDirectory = outputDirectory;
    }
}

