/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.gwt.GwtArtifactResolver;
import org.codehaus.mojo.gwt.GwtRuntime;
import org.codehaus.mojo.gwt.shell.ClasspathBuilder;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGwtMojo
extends AbstractMojo
implements Contextualizable,
GwtArtifactResolver {
    public static final String GWT_GROUP_ID = "com.google.gwt";
    protected ArtifactResolver resolver;
    protected ArtifactFactory artifactFactory;
    protected ArchiverManager archiverManager;
    protected ClasspathBuilder classpathBuilder;
    protected ArtifactRepository localRepository;
    protected List<ArtifactRepository> remoteRepositories;
    private MavenProject project;
    private String gwtVersion;
    private File gwtHome;
    private File generateDirectory;
    private File webappDirectory;
    protected File warSourceDirectory;
    private boolean inplace;

    public File getOutputDirectory() {
        return this.inplace ? this.warSourceDirectory : this.webappDirectory;
    }

    public final void contextualize(Context context) throws ContextException {
        PlexusContainer plexusContainer = (PlexusContainer)context.get((Object)"plexus");
        try {
            this.archiverManager = (ArchiverManager)plexusContainer.lookup(ArchiverManager.ROLE);
        }
        catch (ComponentLookupException e) {
            throw new ContextException(e.getMessage(), (Throwable)e);
        }
    }

    protected int addClasspathElements(Collection<?> elements, URL[] urls, int startPosition) throws MojoExecutionException {
        for (Object object : elements) {
            try {
                urls[startPosition] = object instanceof Artifact ? ((Artifact)object).getFile().toURI().toURL() : (object instanceof Resource ? new File(((Resource)object).getDirectory()).toURI().toURL() : new File((String)object).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Failed to convert original classpath element " + object + " to URL.", (Exception)e);
            }
            ++startPosition;
        }
        return startPosition;
    }

    public Collection<File> getClasspath(String scope, GwtRuntime runtime) throws MojoExecutionException, DependencyResolutionRequiredException {
        return this.classpathBuilder.buildClasspathList(this.getProject(), scope, runtime, this.getProjectArtifacts());
    }

    public GwtRuntime getGwtRuntime() throws MojoExecutionException {
        if (this.gwtHome != null && !StringUtils.isEmpty((String)this.gwtHome.getPath())) {
            this.getLog().info((CharSequence)("using GWT jars from local installation " + this.gwtHome));
            return new GwtRuntime(this.gwtHome);
        }
        if (this.gwtVersion != null) {
            this.getLog().info((CharSequence)("using GWT jars for specified version " + this.gwtVersion));
            return this.getGwtRuntimeForVersion(this.gwtVersion);
        }
        this.detectGwtVersion();
        if (this.gwtVersion == null) {
            this.getLog().error((CharSequence)"no gwtHome, gwtVersion or com.google.gwt:gwt-user dependency set");
            throw new MojoExecutionException("Cannot resolve GWT version");
        }
        this.checkGwtDevAsDependency();
        return this.getGwtRuntimeForVersion(this.gwtVersion);
    }

    private void detectGwtVersion() {
        Set artifacts = this.getProject().getArtifacts();
        for (Artifact artifact : artifacts) {
            if (!GWT_GROUP_ID.equals(artifact.getGroupId()) || !"gwt-user".equals(artifact.getArtifactId())) continue;
            this.gwtVersion = artifact.getVersion();
            if (this.gwtVersion == null) break;
            this.getLog().info((CharSequence)("using GWT jars from project dependencies : " + this.gwtVersion));
            break;
        }
        if (this.gwtVersion == null && this.getProject().getDependencyManagement() != null && this.getProject().getDependencyManagement().getDependencies() != null) {
            List dependencyManagement = this.getProject().getDependencyManagement().getDependencies();
            for (Dependency dependency : dependencyManagement) {
                if (!GWT_GROUP_ID.equals(dependency.getGroupId()) || !"gwt-user".equals(dependency.getArtifactId())) continue;
                this.gwtVersion = dependency.getVersion();
                this.getLog().info((CharSequence)("using GWT jars from project dependencyManagement section : " + this.gwtVersion));
                break;
            }
        }
    }

    private void checkGwtDevAsDependency() {
        for (Artifact artifact : this.getProject().getArtifacts()) {
            if (!GWT_GROUP_ID.equals(artifact.getGroupId()) || !"gwt-dev".equals(artifact.getArtifactId())) continue;
            this.getLog().warn((CharSequence)"You should not declare gwt-dev as a project dependency. This may introduce complex dependency conflicts");
        }
    }

    private GwtRuntime getGwtRuntimeForVersion(String version) throws MojoExecutionException {
        GwtRuntime runtime = new GwtRuntime(version, this);
        return runtime;
    }

    @Override
    public Artifact resolve(String artifactId, String version, String type, String classifier) throws MojoExecutionException {
        String groupId = GWT_GROUP_ID;
        return this.resolve(groupId, artifactId, version, type, classifier);
    }

    protected Artifact resolve(String groupId, String artifactId, String version, String type, String classifier) throws MojoExecutionException {
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
        try {
            this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("artifact not found - " + e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("artifact resolver problem - " + e.getMessage(), (Exception)((Object)e));
        }
        return artifact;
    }

    protected void addCompileSourceRoot(File path) {
        this.getProject().addCompileSourceRoot(path.getAbsolutePath());
    }

    public MavenProject getProject() {
        return this.project;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public List<ArtifactRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public File getGenerateDirectory() {
        if (!this.generateDirectory.exists()) {
            this.getLog().debug((CharSequence)("Creating target directory " + this.generateDirectory.getAbsolutePath()));
            this.generateDirectory.mkdirs();
        }
        return this.generateDirectory;
    }

    @Override
    public ArchiverManager getArchiverManager() {
        return this.archiverManager;
    }

    public Set<Artifact> getProjectArtifacts() {
        return this.project.getArtifacts();
    }
}

