/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.Annotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.gwt.AbstractGwtMojo;
import org.codehaus.plexus.util.DirectoryScanner;

public class GenerateAsyncMojo
extends AbstractGwtMojo {
    private static final String REMOTE_SERVICE_INTERFACE = "com.google.gwt.user.client.rpc.RemoteService";
    private static final Map<String, String> WRAPPERS = new HashMap<String, String>();
    private String servicePattern;
    private boolean returnRequest;
    private String rpcPattern;
    private boolean failOnError;
    private boolean force;
    private String encoding;

    public void execute() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"GenerateAsyncMojo#execute()");
        if (this.encoding == null) {
            this.getLog().warn((CharSequence)"Encoding is not set, your build will be platform dependent");
            this.encoding = Charset.defaultCharset().name();
        }
        boolean supportJava5 = this.getGwtRuntime().getVersion().supportJava5();
        JavaDocBuilder builder = this.createJavaDocBuilder();
        List sourceRoots = this.getProject().getCompileSourceRoots();
        boolean generated = false;
        for (String sourceRoot : sourceRoots) {
            try {
                generated |= this.scanAndGenerateAsync(new File(sourceRoot), builder, supportJava5);
            }
            catch (Throwable e) {
                this.getLog().error((CharSequence)"Failed to generate Async interface", e);
                if (!this.failOnError) continue;
                throw new MojoExecutionException("Failed to generate Async interface", e);
            }
        }
        if (generated) {
            this.getLog().debug((CharSequence)("add compile source root " + this.getGenerateDirectory()));
            this.addCompileSourceRoot(this.getGenerateDirectory());
        }
    }

    private boolean scanAndGenerateAsync(File sourceRoot, JavaDocBuilder builder, boolean supportJava5) throws Exception {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceRoot);
        scanner.setIncludes(new String[]{this.servicePattern});
        scanner.scan();
        String[] sources = scanner.getIncludedFiles();
        if (sources.length == 0) {
            return false;
        }
        boolean fileGenerated = false;
        for (String source : sources) {
            File sourceFile = new File(sourceRoot, source);
            File targetFile = this.getTargetFile(source);
            if (this.isUpToDate(sourceFile, targetFile)) {
                this.getLog().debug((CharSequence)(targetFile.getAbsolutePath() + " is up to date. Generation skipped"));
                fileGenerated = true;
                continue;
            }
            String className = this.getTopLevelClassName(source);
            JavaClass clazz = builder.getClassByName(className);
            if (!this.isEligibleForGeneration(clazz)) continue;
            targetFile.getParentFile().mkdirs();
            this.generateAsync(clazz, targetFile, supportJava5);
            fileGenerated = true;
        }
        return fileGenerated;
    }

    private boolean isUpToDate(File sourceFile, File targetFile) {
        return !this.force && targetFile.exists() && targetFile.lastModified() > sourceFile.lastModified();
    }

    private File getTargetFile(String source) {
        String targetFileName = source.substring(0, source.length() - 5) + "Async.java";
        File targetFile = new File(this.getGenerateDirectory(), targetFileName);
        return targetFile;
    }

    private void generateAsync(JavaClass clazz, File targetFile, boolean supportJava5) throws IOException {
        JavaMethod[] methods;
        PrintWriter writer = new PrintWriter(targetFile, this.encoding);
        String className = clazz.getName();
        if (clazz.getPackage() != null) {
            writer.println("package " + clazz.getPackageName() + ";");
            writer.println();
        }
        writer.println("import com.google.gwt.core.client.GWT;");
        writer.println("import com.google.gwt.user.client.rpc.AsyncCallback;");
        writer.println("import com.google.gwt.user.client.rpc.ServiceDefTarget;");
        writer.println();
        writer.println("public interface " + className + "Async");
        writer.println("{");
        for (JavaMethod method : methods = clazz.getMethods(true)) {
            writer.println("");
            writer.println("    /**");
            writer.println("     * GWT-RPC service  asynchronous (client-side) interface");
            writer.println("     * @see " + clazz.getFullyQualifiedName());
            writer.println("     */");
            if (this.returnRequest) {
                writer.print("    com.google.gwt.http.client.Request " + method.getName() + "( ");
            } else {
                writer.print("    void " + method.getName() + "( ");
            }
            JavaParameter[] params = method.getParameters();
            for (int j = 0; j < params.length; ++j) {
                JavaParameter param = params[j];
                if (j > 0) {
                    writer.print(", ");
                }
                writer.print(param.getType().getGenericValue());
                for (int dimensionIndex = 0; dimensionIndex < param.getType().getDimensions(); ++dimensionIndex) {
                    writer.print("[]");
                }
                writer.print(" " + param.getName());
            }
            if (params.length > 0) {
                writer.print(", ");
            }
            if (supportJava5) {
                if (method.getReturns().isVoid()) {
                    writer.println("AsyncCallback<Void> callback );");
                } else if (method.getReturns().isPrimitive()) {
                    String primitive = method.getReturns().getGenericValue();
                    writer.println("AsyncCallback<" + WRAPPERS.get(primitive) + "> callback );");
                } else {
                    String type = method.getReturns().getGenericValue();
                    for (int dimensionIndex = 0; dimensionIndex < method.getReturns().getDimensions(); ++dimensionIndex) {
                        type = type + "[]";
                    }
                    writer.println("AsyncCallback<" + type + "> callback );");
                }
            } else {
                writer.println("AsyncCallback callback );");
            }
            writer.println();
        }
        writer.println();
        String uri = MessageFormat.format(this.rpcPattern, className);
        if (clazz.getAnnotations() != null) {
            for (Annotation annotation : clazz.getAnnotations()) {
                this.getLog().debug((CharSequence)("annotation found on service interface " + annotation));
                if (!annotation.getType().getValue().equals("com.google.gwt.user.client.rpc.RemoteServiceRelativePath")) continue;
                uri = annotation.getNamedParameter("value").toString();
                uri = uri.substring(1, uri.length() - 1);
                this.getLog().debug((CharSequence)("@RemoteServiceRelativePath annotation found on service interface " + uri));
            }
        }
        writer.println("    /**");
        writer.println("     * Utility class to get the RPC Async interface from client-side code");
        writer.println("     */");
        writer.println("    public static final class Util ");
        writer.println("    { ");
        writer.println("        private static " + className + "Async instance;");
        writer.println();
        writer.println("        public static final " + className + "Async getInstance()");
        writer.println("        {");
        writer.println("            if ( instance == null )");
        writer.println("            {");
        writer.println("                instance = (" + className + "Async) GWT.create( " + className + ".class );");
        writer.println("                ServiceDefTarget target = (ServiceDefTarget) instance;");
        writer.println("                target.setServiceEntryPoint( GWT.getModuleBaseURL() + \"" + uri + "\" );");
        writer.println("            }");
        writer.println("            return instance;");
        writer.println("        }");
        writer.println("");
        writer.println("        private Util()");
        writer.println("        {");
        writer.println("            // Utility class should not be instanciated");
        writer.println("        }");
        writer.println("    }");
        writer.println("}");
        writer.close();
    }

    private boolean isEligibleForGeneration(JavaClass javaClass) {
        return javaClass.isInterface() && javaClass.isPublic() && javaClass.isA(REMOTE_SERVICE_INTERFACE);
    }

    private JavaDocBuilder createJavaDocBuilder() throws MojoExecutionException {
        try {
            JavaDocBuilder builder = new JavaDocBuilder();
            builder.setEncoding(this.encoding);
            builder.getClassLibrary().addClassLoader(this.getProjectClassLoader());
            for (String sourceRoot : this.getProject().getCompileSourceRoots()) {
                builder.getClassLibrary().addSourceFolder(new File(sourceRoot));
            }
            return builder;
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Failed to resolve project classpath", (Exception)e);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Failed to resolve project classpath", (Exception)((Object)e));
        }
    }

    private String getTopLevelClassName(String sourceFile) {
        String className = sourceFile.substring(0, sourceFile.length() - 5);
        return className.replace(File.separatorChar, '.');
    }

    protected ClassLoader getProjectClassLoader() throws DependencyResolutionRequiredException, MalformedURLException {
        this.getLog().debug((CharSequence)"AbstractMojo#getProjectClassLoader()");
        List compile = this.getProject().getCompileClasspathElements();
        URL[] urls = new URL[compile.size()];
        int i = 0;
        for (Object object : compile) {
            urls[i] = object instanceof Artifact ? ((Artifact)object).getFile().toURI().toURL() : new File((String)object).toURI().toURL();
            ++i;
        }
        return new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
    }

    static {
        WRAPPERS.put("boolean", Boolean.class.getName());
        WRAPPERS.put("byte", Byte.class.getName());
        WRAPPERS.put("char", Character.class.getName());
        WRAPPERS.put("short", Short.class.getName());
        WRAPPERS.put("int", Integer.class.getName());
        WRAPPERS.put("long", Long.class.getName());
        WRAPPERS.put("float", Float.class.getName());
        WRAPPERS.put("double", Double.class.getName());
    }
}

