/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.gwt.GwtModuleReader;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtModule {
    private Xpp3Dom xml;
    private String name;
    private Set<GwtModule> inherits;
    private GwtModuleReader reader;

    public GwtModule(String name, Xpp3Dom xml, GwtModuleReader reader) {
        this.name = name;
        this.xml = xml;
        this.reader = reader;
    }

    private String getRenameTo() {
        return this.xml.getAttribute("rename-to");
    }

    public String getPublic() {
        Xpp3Dom node = this.xml.getChild("public");
        return node == null ? "public" : node.getAttribute("path");
    }

    public String[] getSuperSources() {
        Xpp3Dom[] nodes = this.xml.getChildren("super-source");
        if (nodes == null) {
            return new String[0];
        }
        String[] superSources = new String[nodes.length];
        int i = 0;
        for (Xpp3Dom node : nodes) {
            String path = node.getAttribute("path");
            if (path == null) {
                path = "";
            }
            superSources[i++] = path;
        }
        return superSources;
    }

    public String[] getSources() {
        Xpp3Dom[] nodes = this.xml.getChildren("source");
        if (nodes == null) {
            return new String[]{"client"};
        }
        String[] sources = new String[nodes.length];
        int i = 0;
        for (Xpp3Dom node : nodes) {
            sources[i++] = node.getAttribute("path");
        }
        return sources;
    }

    public List<String> getEntryPoints() throws MojoExecutionException {
        ArrayList<String> entryPoints = new ArrayList<String>();
        entryPoints.addAll(this.getLocalEntryPoints());
        for (GwtModule module : this.getInherits()) {
            entryPoints.addAll(module.getLocalEntryPoints());
        }
        return entryPoints;
    }

    private List<String> getLocalEntryPoints() {
        Xpp3Dom[] nodes = this.xml.getChildren("entry-point");
        if (nodes == null) {
            return Collections.emptyList();
        }
        ArrayList<String> entryPoints = new ArrayList<String>(nodes.length);
        for (Xpp3Dom node : nodes) {
            entryPoints.add(node.getAttribute("class"));
        }
        return entryPoints;
    }

    public Set<GwtModule> getInherits() throws MojoExecutionException {
        if (this.inherits != null) {
            return this.inherits;
        }
        this.inherits = new HashSet<GwtModule>();
        this.addInheritedModules(this.inherits, this.getLocalInherits());
        return this.inherits;
    }

    private void addInheritedModules(Set<GwtModule> set, Set<GwtModule> modules) throws MojoExecutionException {
        for (GwtModule module : modules) {
            if (!set.add(module)) continue;
            this.addInheritedModules(set, module.getLocalInherits());
        }
    }

    private Set<GwtModule> getLocalInherits() throws MojoExecutionException {
        Xpp3Dom[] nodes = this.xml.getChildren("inherits");
        if (nodes == null) {
            return Collections.emptySet();
        }
        HashSet<GwtModule> modules = new HashSet<GwtModule>();
        for (Xpp3Dom node : nodes) {
            String moduleName = node.getAttribute("name");
            if (moduleName.startsWith("com.google.gwt.")) continue;
            modules.add(this.reader.readModule(moduleName));
        }
        return modules;
    }

    public Map<String, String> getServlets() throws MojoExecutionException {
        return this.getServlets(this.getPath());
    }

    public Map<String, String> getServlets(String path) throws MojoExecutionException {
        Map<String, String> servlets = this.getLocalServlets(path);
        for (GwtModule module : this.getInherits()) {
            servlets.putAll(module.getLocalServlets(path));
        }
        return servlets;
    }

    private Map<String, String> getLocalServlets(String path) {
        HashMap<String, String> servlets = new HashMap<String, String>();
        Xpp3Dom[] nodes = this.xml.getChildren("servlet");
        if (nodes != null) {
            for (Xpp3Dom node : nodes) {
                servlets.put(path + node.getAttribute("path"), node.getAttribute("class"));
            }
        }
        return servlets;
    }

    public String getName() {
        return this.name;
    }

    public String getPackage() {
        return this.name.substring(0, this.name.lastIndexOf(46));
    }

    public String getPath() {
        if (this.getRenameTo() != null) {
            return this.getRenameTo();
        }
        return this.name;
    }

    public boolean equals(Object obj) {
        return this.name.equals(((GwtModule)obj).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

