/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.gwt.AbstractGwtModuleMojo;
import org.codehaus.mojo.gwt.GwtModule;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtResourcesMojo
extends AbstractGwtModuleMojo {
    private File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        HashSet<String> sourcesAndResources = new HashSet<String>();
        sourcesAndResources.addAll(this.getProject().getCompileSourceRoots());
        for (Resource resource : this.getProject().getResources()) {
            sourcesAndResources.add(resource.getDirectory());
        }
        for (String name : this.getModules()) {
            GwtModule module = this.readModule(name);
            this.copyDescriptor(module, sourcesAndResources);
            int count = 1;
            for (String source : module.getSources()) {
                this.getLog().debug((CharSequence)("copy GWT sources from " + name + '.' + source));
                count += this.copyAsResources(module, source, sourcesAndResources, "**/*.java");
            }
            for (String source : module.getSuperSources()) {
                this.getLog().debug((CharSequence)("copy GWT super-sources from " + name + '.' + source));
                count += this.copyAsResources(module, source, sourcesAndResources, "**/*.java");
            }
            this.getLog().info((CharSequence)(count + " source files copied from GWT module " + name));
        }
    }

    private int copyAsResources(GwtModule module, String source, Set<String> paths, String include) throws MojoExecutionException {
        String pattern = module.getPackage().replace('.', '/');
        int count = 0;
        for (String path : paths) {
            String[] includedFiles;
            File basedir = new File(path);
            if (!basedir.exists()) continue;
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(basedir);
            scanner.setIncludes(new String[]{pattern + '/' + source + '/' + include});
            scanner.scan();
            for (String included : includedFiles = scanner.getIncludedFiles()) {
                File f = new File(basedir, included);
                File target = new File(this.outputDirectory, included);
                try {
                    this.getLog().debug((CharSequence)("copy " + f + " to outputDirectory"));
                    target.getParentFile().mkdirs();
                    FileUtils.copyFile((File)f, (File)target);
                    ++count;
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to copy GWT class source " + f, (Exception)e);
                }
            }
        }
        return count;
    }

    private void copyDescriptor(GwtModule module, Set<String> paths) throws MojoExecutionException {
        String moduleFilePath = module.getName().replace('.', '/') + ".gwt.xml";
        for (String path : paths) {
            File basedir = new File(path);
            File descriptor = new File(basedir, moduleFilePath);
            if (!descriptor.exists()) continue;
            File target = new File(this.outputDirectory, moduleFilePath);
            try {
                this.getLog().debug((CharSequence)("copy " + descriptor + " to outputDirectory"));
                target.getParentFile().mkdirs();
                FileUtils.copyFile((File)descriptor, (File)target);
                return;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy GWT descriptor " + descriptor, (Exception)e);
            }
        }
        throw new MojoExecutionException("Failed to retrieve GWT descriptor in project sources " + moduleFilePath);
    }
}

