/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.mojo.gwt.GwtArtifactResolver;
import org.codehaus.mojo.gwt.GwtVersion;
import org.codehaus.mojo.gwt.shell.ArtifactNameUtil;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;

public class GwtRuntime {
    private final File gwtUserJar;
    private final File gwtDevJar;
    private final File soycJar;
    private final GwtVersion version;

    public GwtRuntime(File gwtHome) throws MojoExecutionException {
        if (!gwtHome.exists()) {
            throw new MojoExecutionException("Invalid GWT home : " + gwtHome);
        }
        this.gwtUserJar = new File(gwtHome, "gwt-user.jar");
        if (!this.gwtUserJar.exists()) {
            throw new MojoExecutionException("Invalid GWT home : " + gwtHome);
        }
        this.gwtDevJar = new File(gwtHome, ArtifactNameUtil.guessDevJarName());
        if (!this.gwtDevJar.exists()) {
            throw new MojoExecutionException("Invalid GWT home : " + gwtHome);
        }
        this.version = GwtVersion.fromMavenVersion(GwtRuntime.readGwtDevVersion(this.gwtDevJar));
        if (this.version.compareTo(GwtVersion.TWO_DOT_ZERO) >= 0) {
            this.soycJar = new File(gwtHome, "gwt-soyc-vis.jar");
            if (!this.soycJar.exists()) {
                throw new MojoExecutionException("Invalid GWT home : " + gwtHome);
            }
        } else {
            this.soycJar = null;
        }
    }

    public GwtRuntime(String version, GwtArtifactResolver resolver) throws MojoExecutionException {
        this.version = GwtVersion.fromMavenVersion(version);
        Artifact gwtUser = resolver.resolve("gwt-user", version, "jar", null);
        this.gwtUserJar = gwtUser.getFile();
        boolean supportOOPHM = this.version.supportOOPHM();
        String platformVersion = supportOOPHM ? null : ArtifactNameUtil.getPlatformName();
        Artifact gwtDev = resolver.resolve("gwt-dev", version, "jar", platformVersion);
        this.gwtDevJar = gwtDev.getFile();
        if (!supportOOPHM) {
            Artifact gwtNatives = resolver.resolve("gwt-dev", version, "zip", ArtifactNameUtil.getPlatformName() + "-libs");
            GwtRuntime.unpackNativeLibraries(gwtNatives.getFile(), resolver.getArchiverManager());
        }
        if (this.version.supportSOYC()) {
            Artifact soyc = resolver.resolve("gwt-soyc-vis", version, "jar", null);
            this.soycJar = soyc.getFile();
        } else {
            this.soycJar = null;
        }
    }

    private static String readGwtDevVersion(File gwtDevJar) {
        try {
            try {
                URL aboutPropreties = new URL("jar:" + gwtDevJar.toURL() + "!/com/google/gwt/dev/About.properties");
                Properties props = new Properties();
                props.load(aboutPropreties.openStream());
                return props.getProperty("gwt.version");
            }
            catch (FileNotFoundException e) {
                URL about = new URL("jar:" + gwtDevJar.toURL() + "!/com/google/gwt/dev/About.class");
                ClassParser parser = new ClassParser(about.openStream(), "About.class");
                JavaClass clazz = parser.parse();
                for (Field field : clazz.getFields()) {
                    if (!"GWT_VERSION_NUM".equals(field.getName())) continue;
                    String constant = field.getConstantValue().toString();
                    return constant.substring(1, constant.length() - 1);
                }
                throw new IllegalStateException("Failed to retrieve GWT_VERSION_NUM in " + gwtDevJar.getName() + " 'About' class");
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to read gwt-dev version from " + gwtDevJar.getAbsolutePath());
        }
    }

    public File getGwtUserJar() {
        return this.gwtUserJar;
    }

    public File getGwtDevJar() {
        return this.gwtDevJar;
    }

    public File getSoycJar() {
        if (this.version.compareTo(GwtVersion.TWO_DOT_ZERO) < 0) {
            throw new IllegalStateException("Cannot use SOYC with GWT SDK prior to 2.0");
        }
        return this.soycJar;
    }

    private static void unpackNativeLibraries(File nativeLibs, ArchiverManager archiverManager) throws MojoExecutionException {
        File timestamp = new File(nativeLibs.getParentFile(), ".gwt-maven-plugin");
        if (timestamp.exists() && timestamp.lastModified() > nativeLibs.lastModified()) {
            return;
        }
        try {
            UnArchiver unArchiver = archiverManager.getUnArchiver(nativeLibs);
            unArchiver.setSourceFile(nativeLibs);
            unArchiver.setDestDirectory(nativeLibs.getParentFile());
            unArchiver.setOverwrite(false);
            unArchiver.extract();
            timestamp.createNewFile();
        }
        catch (IOException e) {
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Failed to retrieve Archiver implementation", (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Failed to unpack native libs", (Exception)((Object)e));
        }
    }

    public GwtVersion getVersion() {
        return this.version;
    }
}

