/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.gwt;

import org.codehaus.mojo.gwt.EmbeddedServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GwtVersion {
    ONE_DOT_FOUR(0, "com.google.gwt.dev.GWTShell", "com.google.gwt.dev.GWTCompiler", EmbeddedServer.TOMCAT, "-out"),
    ONE_DOT_FIVE(GwtVersion.ONE_DOT_FOUR.capabilities + 1, "com.google.gwt.dev.GWTShell", "com.google.gwt.dev.GWTCompiler", EmbeddedServer.TOMCAT, "-out"),
    ONE_DOT_SIX(GwtVersion.ONE_DOT_FIVE.capabilities + 2 + 8, "com.google.gwt.dev.HostedMode", "com.google.gwt.dev.Compiler", EmbeddedServer.JETTY, "-war"),
    ONE_DOT_SEVEN(GwtVersion.ONE_DOT_SIX.capabilities, "com.google.gwt.dev.HostedMode", "com.google.gwt.dev.Compiler", EmbeddedServer.JETTY, "-war"),
    TWO_DOT_ZERO(GwtVersion.ONE_DOT_SEVEN.capabilities + 4 + 16 + 32, "com.google.gwt.dev.DevMode", "com.google.gwt.dev.Compiler", EmbeddedServer.JETTY, "-war");

    private int capabilities;
    private String shellFQCN;
    private String compilerFQCN;
    private EmbeddedServer emebededServer;
    private String webOutputArgument;

    static GwtVersion fromMavenVersion(String version) {
        if (version.startsWith("1.4")) {
            return ONE_DOT_FOUR;
        }
        if (version.startsWith("1.5")) {
            return ONE_DOT_FIVE;
        }
        if (version.startsWith("1.6")) {
            return ONE_DOT_SIX;
        }
        if (version.startsWith("1.7")) {
            return ONE_DOT_SEVEN;
        }
        if (version.startsWith("2.")) {
            return TWO_DOT_ZERO;
        }
        throw new IllegalStateException("Unsupported GWT version " + version);
    }

    private GwtVersion(int capabilities, String shellFQCN, String compilerFQCN, EmbeddedServer emebededServer, String webOutputArgument) {
        this.capabilities = capabilities;
        this.shellFQCN = shellFQCN;
        this.compilerFQCN = compilerFQCN;
        this.webOutputArgument = webOutputArgument;
        this.emebededServer = emebededServer;
    }

    public String getShellFQCN() {
        return this.shellFQCN;
    }

    public String getCompilerFQCN() {
        return this.compilerFQCN;
    }

    public EmbeddedServer getEmbeddedServer() {
        return this.emebededServer;
    }

    public boolean supportJava5() {
        return (this.capabilities & 1) != 0;
    }

    public boolean supportMultiModuleCompile() {
        return (this.capabilities & 8) != 0;
    }

    public boolean supportMultiModuleShell() {
        return (this.capabilities & 4) != 0;
    }

    public boolean supportParallelCompile() {
        return (this.capabilities & 2) != 0;
    }

    public boolean supportSOYC() {
        return (this.capabilities & 0x10) != 0;
    }

    public boolean supportOOPHM() {
        return (this.capabilities & 0x20) != 0;
    }

    public String getWebOutputArgument() {
        return this.webOutputArgument;
    }

    static final class Capabilities {
        static final int JAVA5_SYNTAX = 1;
        static final int PARALLEL_COMPILER = 2;
        static final int MULTI_MODULE_SHELL = 4;
        static final int MULTI_MODULE_COMPILER = 8;
        static final int SOYC = 16;
        static final int OOPHM = 32;

        Capabilities() {
        }
    }
}

